/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.hibernate;

import java.io.IOException;

import javax.persistence.Entity;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

import br.com.linkcom.neo.classmanager.ClassManager;
import br.com.linkcom.neo.classmanager.ClassRegister;
import br.com.linkcom.neo.classmanager.WebClassRegister;

/**
 * @author rogelgarcia
 * @since 18/10/2005
 * @version 1.0
 */
public class DefaultEntityFinder implements EntityFinder, ApplicationContextAware {

	private static final String NEO_PACKAGE = "br.com.linkcom.neo";
	private ApplicationContext applicationContext;
	private ClassManager classManager;

	public void setClassManager(ClassManager classManager) {
		this.classManager = classManager;
	}

	public Class<?>[] findEntities() throws IOException {
		
		if (classManager == null) {
			if (applicationContext instanceof WebApplicationContext) {
				classManager = WebClassRegister.getClassManager(
						((WebApplicationContext) applicationContext)
								.getServletContext(), NEO_PACKAGE);
			} else {
				classManager = ClassRegister.getClassManager();
			}
		}
		return classManager.getClassesWithAnnotation(Entity.class);
	}

	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

}
