/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.core.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.init.ContextLoaderListener;
import br.com.linkcom.neo.exception.NotInNeoContextException;

/**
 * @author rogelgarcia
 * @since 21/01/2006
 * @version 1.1
 */
public class NeoWeb extends Neo {
	
	protected static final Log log = LogFactory.getLog(NeoWeb.class);

	public static void createRequestContext(HttpServletRequest request, HttpServletResponse response){
		if(request == null || response == null){
			throw new NullPointerException();
		}
		ServletContext servletContext = request.getSession().getServletContext();
		
		getWebApplicationContext(servletContext);

		getRequestContext(request, response);
		
	}
	
	public static WebRequestContext getRequestContext() throws NotInNeoContextException{
		WebRequestContext context = (WebRequestContext) requestContext.get();
		if(context == null){
			StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();

			String msg = "O cdigo no est sendo executado em um contexto NEO!";
			if (stackTrace.length>=4) {
				msg += "\nClasse: "+stackTrace[3].getClassName()+" " +
						"\nMtodo: "+stackTrace[3].getMethodName()+" " +
						"\nLinha: "+stackTrace[3].getLineNumber();
			}
			msg += "\nSe voc estiver executanto em um ambiente J2EE, verifique se voc configurou no web.xml o filtro da classe ???."+//TODO MirageContextFilter.class.getName() +
					"\nA configurao desse filtro  importante porque  ele quem cria o contexto NEO.";
			
			throw new NotInNeoContextException(msg);
		}
		return context;
	}
	
	
	public static void createApplicationContext(ServletContext servletContext, Config config){
	
		WebApplicationContext applicationContext;
		applicationContext = new DefaultWebApplicationContext(config, servletContext);
		servletContext.setAttribute(WebApplicationContext.APPLICATION_CONTEXT_ATTRIBUTE, applicationContext);
		
		Neo.applicationContext.set(applicationContext);
	}

	public static WebRequestContext getRequestContext(HttpServletRequest request, HttpServletResponse response) {
		//verificar se j existe um request context
		getWebApplicationContext(request.getSession().getServletContext());
		WebRequestContext requestContext = (WebRequestContext) request.getAttribute(WebRequestContext.REQUEST_CONTEXT_ATTRIBUTE);
		if(requestContext == null){
			log.trace("Criando contexto de requisio Neo... ");
			requestContext = new DefaultWebRequestContext(request, response, getWebApplicationContext(request.getSession().getServletContext()));
			request.setAttribute(WebRequestContext.REQUEST_CONTEXT_ATTRIBUTE, requestContext);
			Neo.requestContext.set(requestContext);
		} else {
			//atualizar o request por causa do multipart
			requestContext = new DefaultWebRequestContext(request, response, getWebApplicationContext(request.getSession().getServletContext()));
			request.setAttribute(WebRequestContext.REQUEST_CONTEXT_ATTRIBUTE, requestContext);
			Neo.requestContext.set(requestContext);
		}
		return requestContext;
	}

	public static WebApplicationContext getWebApplicationContext(ServletContext servletContext) {
		//verificar se j existe um applicationContext
		WebApplicationContext applicationContext = (WebApplicationContext) servletContext.getAttribute(WebApplicationContext.APPLICATION_CONTEXT_ATTRIBUTE);
		if(applicationContext == null){
			throw new NotInNeoContextException("O contexto de aplicao NEO ainda no foi criado. Verifique se o listener "+ContextLoaderListener.class.getName()+" est configurado no web.xml");
		}
		Neo.applicationContext.set(applicationContext);
		return applicationContext;
	}
}
