/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.core.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.linkcom.neo.util.LocaleUtils;
import br.com.linkcom.neo.view.SelecionarCadastrarServlet;
import br.com.linkcom.neo.view.menu.MenuTag;

/**
 * @author rogelgarcia
 * @since 21/01/2006
 * @version 1.1
 */
public class NeoFilter implements Filter {

	public void init(FilterConfig config) throws ServletException {
		
	}

	public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
		long inicio = System.currentTimeMillis();

		HttpServletRequest request = (HttpServletRequest) req;
		HttpServletResponse response = (HttpServletResponse) res;
		
		//I18N
		String locale = request.getParameter("locale");
		if (locale != null){
			request.getSession().setAttribute(LocaleUtils.LOCALE_SESSION_KEY, locale);
			request.getSession().setAttribute(MenuTag.MENU_CACHE_MAP, null);
		}
		
		//colocar um flag na requisio indicando que esta  uma pgina selectone ou cadastrar
		String parameter = request.getParameter(SelecionarCadastrarServlet.INSELECTONE);
		if("true".equals(parameter)){
			request.setAttribute(SelecionarCadastrarServlet.INSELECTONE, true);
		}
		
		//cria o contexto de requisicao NEO
		NeoWeb.createRequestContext(request, response);
		
		if(request.getRequestURI().equals(request.getContextPath()+"/neo")){
			String url = "/WEB-INF/classes/br/com/linkcom/neo/resource/neo.jsp";
			ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
			PrintWriter writer = new PrintWriter(arrayOutputStream);
		
			RequestDispatcher requestDispatcher = null;
			requestDispatcher = request.getRequestDispatcher(url);
			requestDispatcher.include(request, response);
			writer.flush();
			response.getWriter().write(arrayOutputStream.toString());
			response.setStatus(HttpServletResponse.SC_OK);
		}
		else {
			String uri = request.getRequestURI();
			if (uri.matches("/.+?/.+?/.*")) {
				request.setAttribute("NEO_MODULO", uri.split("/")[2]);
			}
			
			chain.doFilter(request, response);
			
			long fim = System.currentTimeMillis();
			long tempo = (fim - inicio);
			if (tempo > 200) {
				System.out.println("Tempo: " + request.getRequestURI() + "  " + (tempo < 10?" ":"") + tempo + " ms");
			}
		}
	}

	public void destroy() {
	}

}