/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.core.standard;

import java.net.MalformedURLException;
import java.net.URL;

import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.exception.NotInNeoContextException;
import br.com.linkcom.neo.util.Util;

/**
 * @author rogelgarcia
 * @since 21/01/2006
 * @version 1.1
 */
public class Neo {
	
	protected static final InheritableThreadLocal<RequestContext> requestContext;
	protected static final InheritableThreadLocal<ApplicationContext> applicationContext;
	protected static String mensagemErro;
	
	static {
		requestContext = new InheritableThreadLocal<RequestContext>();
		applicationContext = new InheritableThreadLocal<ApplicationContext>();
		
	}
	
	public static boolean isInApplicationContext(){
		return applicationContext.get() != null;
	}

	public static void setRequestContext(RequestContext context){
		requestContext.set(context);
		applicationContext.set(context.getApplicationContext());
	}
	
	public static void setApplicationContext(ApplicationContext context){
		applicationContext.set(context);
	}
	
	/**
	 * Retorna um objeto registrado no Spring de determinada classe 
	 * <B>IMPORTANTE: O nome do objeto registrado deve ser o nome simples da classe com a primeira 
	 * letra minscula</B>
	 */
	@SuppressWarnings("unchecked")
	public static <E> E getObject(Class<E> clazz) {
		return (E)Neo.getApplicationContext().getBean(Util.strings.uncaptalize(clazz.getSimpleName()));
	}
	
	public static User getUser(){
		return Neo.getRequestContext().getUser();
	}
	
	/**
	 * Retorna o contexto NEO
	 * @return
	 * @throws NotInNeoContextException se no existir um contexto Neo nessa Thread
	 */
	public static RequestContext getRequestContext() throws NotInNeoContextException{
		RequestContext neoContext = requestContext.get();
		if(neoContext == null){
			StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
			throw new NotInNeoContextException("O cdigo no est sendo excecutado em um contexto NEO! " +
							"\nClasse: "+stackTrace[3].getClassName()+" " +
							"\nMtodo: "+stackTrace[3].getMethodName()+" " +
							"\nLinha: "+stackTrace[3].getLineNumber() +
							"\n\nSe voc estiver excecutanto em um ambiente J2EE verifique se voc configurou no web.xml o filtro da classe "+
							", \na configurao desse filtro  importante porque  ele que cria o contexto NEO");
		}
		return neoContext;
	}
	
	public static ApplicationContext getApplicationContext() throws NotInNeoContextException{
		ApplicationContext neoApplicationContext = applicationContext.get();
		if(neoApplicationContext == null){
			StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
			throw new NotInNeoContextException("O cdigo no est sendo excecutado em um contexto NEO! " +
							"\nClasse: "+stackTrace[3].getClassName()+" " +
							"\nMtodo: "+stackTrace[3].getMethodName()+" " +
							"\nLinha: "+stackTrace[3].getLineNumber() +
							"\n\nSe voc estiver excecutanto em um ambiente J2EE verifique se voc configurou no web.xml o listener da classe br.com.linkcom.neo.core.web.init.ContextLoaderListener e o filtro br.com.linkcom.neo.core.web.NeoFilter. \n" +
							"Ao criar uma nova Thread o contexto deve ser copiado da Thread inicial!");
		}
		return neoApplicationContext;
	}
	
	public static String getApplicationName(){
		ApplicationContext applicationContext2 = Neo.getApplicationContext();
		if(applicationContext2 instanceof WebApplicationContext){
			try {
				URL resource = ((WebApplicationContext)applicationContext2).getServletContext().getResource("/");
				
				String path = resource.getPath();
				path = path.substring(0, path.lastIndexOf('/'));
				path = path.substring(path.lastIndexOf('/')+1);
				return path; 
			} catch (MalformedURLException e) {
				throw new RuntimeException(e);
			}
		} else {
			return "";
		}
	}


}
