/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.core.standard;

import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.controller.Message;
import br.com.linkcom.neo.controller.MessageType;

/**
 * @author rogelgarcia
 * @since 13/07/2006
 * @version 1.0
 */
public class DefaultRequestContext implements RequestContext {
	
	User user;
	
	private ApplicationContext applicationContext;

	public DefaultRequestContext(ApplicationContext applicationContext){
		this.applicationContext = applicationContext;
	}

	public ApplicationContext getApplicationContext() {
		return applicationContext;
	}

	public String getRequestQuery() {
		return null;
	}

	public Message[] getMessages() {
		return null;
	}

	public void addMessage(Object source) {
		
	}

	public void addMessage(Object source, MessageType type) {
		
	}

	public void addError(Object source) {
		
	}

	public void clearMessages() {
		
	}

	public String getParameter(String parameter) {
		return null;
	}

	public void setAttribute(String name, Object value) {
		
	}

	public Object getAttribute(String name) {
		return null;
	}

	public User getUser() {
		return user;
	}
	

	public boolean hasRole(String role) {
		return false;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Object getUserAttribute(String name) {
		return null;
	}

	public void setUserAttribute(String name, Object value) {
	
	}

}
