/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.core.standard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import br.com.linkcom.neo.classmanager.ClassManager;
import br.com.linkcom.neo.classmanager.ClassRegister;
import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.exception.NeoException;

/**
 * @author rogelgarcia
 * @since 21/01/2006
 * @version 1.1
 */
public class DefaultApplicationContext extends AbstractApplicationContext {
	
	Map<String, Object> attributes = new HashMap<String, Object>();
	private ClassManager classManager;

	public DefaultApplicationContext(Config config) {
		super(config);
	}

	public ClassManager getClassManager() {
		if(classManager == null){
			try {
				classManager = ClassRegister.getClassManager();
			} catch (IOException e) {
				throw new NeoException(e);
			}
		}
		return classManager;
	}

	public void setAttribute(String s, Object value) {
		attributes.put(s, value);
	}

	public Object getAttribute(String s) {
		return attributes.get(s);
	}



}
