/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.core.standard;

import br.com.linkcom.neo.authorization.AuthorizationManager;
import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.report.ReportGenerator;
import br.com.linkcom.neo.rtf.RTFGenerator;

/**
 * @author rogelgarcia
 * @since 21/01/2006
 * @version 1.1
 */
public abstract class AbstractApplicationContext implements ApplicationContext{

	protected Config config;
	
	public <E> BeanDescriptor<E> getBeanDescriptor(E bean, Class<E> clazz) {
		return config.getBeanDescriptorFactory().createBeanDescriptor(bean, clazz);
	}

	public <E> BeanDescriptor<E> getBeanDescriptor(E bean) {
		return config.getBeanDescriptorFactory().createBeanDescriptor(bean);
	}

	public AuthorizationManager getAuthorizationManager() {
		return config.getAuthorizationManager();
	}

	public AbstractApplicationContext(Config config){
		this.config = config;
	}

	public ReportGenerator getReportGenerator() {
		return config.getReportGenerator();
	}
	
	public RTFGenerator getRTFGenerator(){
		return config.getRTFGenerator();
	}

	public Config getConfig() {
		return config;
	}
	
	public Object getBean(String string) {
		return config.getDefaultListableBeanFactory().getBean(string);
	}
	
}
