/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.controller.resource;

import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;

import br.com.linkcom.neo.core.web.WebRequestContext;

/**
 * @author rogelgarcia
 * @since 02/02/2006
 * @version 1.1
 */
public abstract class ResourceSenderController<FILTRO> extends AbstractResourceSenderController<FILTRO> {

	@Override
	public ModelAndView doGerar(WebRequestContext request, FILTRO filtro) throws Exception {
		HttpServletResponse response = request.getServletResponse();
		Resource recurso = generateResource(request, filtro);
		if (recurso == null) {
			// TODO DEVERIA SER CRIADO OUTRO CONTROLER PARA MANDAR EMAILS POR EXEMPLO
			// ESSE AQUI  PARA ENVIAR COISAS PARA O CLIENTE, FAZER DOWNLOAD
			return goToAction(FILTRO);
		}
		response.setContentType(recurso.getContentType());
		
		response.addHeader("Content-Disposition", "attachment; filename=\"" + recurso.getFileName() + "\";");
		response.getOutputStream().write(recurso.getContents());
		return null;
	}

	public abstract Resource generateResource(WebRequestContext request, FILTRO filtro) throws Exception;

}
