/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.controller.crud;

import org.springframework.web.servlet.ModelAndView;

import br.com.linkcom.neo.controller.Action;
import br.com.linkcom.neo.controller.Command;
import br.com.linkcom.neo.controller.DefaultAction;
import br.com.linkcom.neo.controller.Input;
import br.com.linkcom.neo.controller.MultiActionController;
import br.com.linkcom.neo.controller.OnErrors;
import br.com.linkcom.neo.core.web.WebRequestContext;

/**
 * @author rogelgarcia
 * @since 01/02/2006
 * @version 1.1
 */
public abstract class AbstractCrudController<FILTRO extends FiltroListagem, FORMBEAN> extends MultiActionController {

	public static final String LISTAGEM = "listagem";

	public static final String ENTRADA = "entrada";

	public static final String CRIAR = "criar";

	public static final String EDITAR = "editar";
	
	public static final String CONSULTAR = "consultar";

	public static final String SALVAR = "salvar";

	public static final String EXCLUIR = "excluir";

	@DefaultAction
	@Action(LISTAGEM)
	@Input(LISTAGEM)
	@Command(session = true, validate = true)
	public abstract ModelAndView doListagem(WebRequestContext request, FILTRO filtro) throws CrudException;

	@Action(ENTRADA)
	@Input(ENTRADA)
	public abstract ModelAndView doEntrada(WebRequestContext request, FORMBEAN form) throws CrudException;

	@Action(CRIAR)
	@OnErrors(LISTAGEM)
	public abstract ModelAndView doCriar(WebRequestContext request, FORMBEAN form) throws CrudException;

	@Action(CONSULTAR)
	public ModelAndView doConsultar(WebRequestContext request, FORMBEAN form) throws CrudException {
		request.setAttribute(CONSULTAR, true);
		return doEditar(request, form);
	}
	
	@Action(EDITAR)
	@OnErrors(LISTAGEM)
	public abstract ModelAndView doEditar(WebRequestContext request, FORMBEAN form) throws CrudException;

	@Action(SALVAR)
	@Command(validate = true)
	@Input(ENTRADA)
	public abstract ModelAndView doSalvar(WebRequestContext request, FORMBEAN form) throws CrudException;

	@Action(EXCLUIR)
	@OnErrors(LISTAGEM)
	public abstract ModelAndView doExcluir(WebRequestContext request, FORMBEAN form) throws CrudException;

}
