/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

import br.com.linkcom.neo.controller.resource.Resource;

public class ResourceModelAndView extends ModelAndView {

	private Resource resource;

	public ResourceModelAndView(Resource resource2){
		this.resource = resource2;
		setView(new View(){
			public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
				response.setContentType(resource.getContentType());
				response.setHeader("Content-Disposition", "attachment; filename=\"" + resource.getFileName() + "\";");
				response.getOutputStream().write(resource.getContents());
				
			}
		});
	}
}
