/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.controller;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.util.Util;

/**
 * @author rogelgarcia
 * @since 25/01/2006
 * @version 1.1
 */
public class MethodNameResolverImpl {
	
	private Class clazz;
	//cache dos actions
	
	private Map<String/*ACTION*/, Method/*MTODO*/> mapAction = new HashMap<String, Method>();

	public MethodNameResolverImpl(Object delegate) {
		this.clazz = delegate.getClass();
	}

	public Method getHandlerMethod(HttpServletRequest request) throws NoSuchRequestHandlingMethodException {
		String actionParameter = request.getParameter(MultiActionController.ACTION_PARAMETER);
		return getHandlerMethod(actionParameter);
	}
	
	public Method getHandlerMethod(String action) throws NoSuchRequestHandlingMethodException {
		Method method = null;
		if((method = mapAction.get(action)) != null){
			return method;
		}
		//se o mtodo nao est no cache ... procurar
		Class[] hierarquia = getHierarquia();
		
		if(Util.strings.isEmpty(action)){
			method = findDefaultAction(hierarquia);	
		}
		if(method == null){
			method = findAction(hierarquia, action);
		}
		if(method == null){
			method = findMethodName(hierarquia, action);
		}
		if(method != null){
			mapAction.put(action, method);
			return method;
		}
		throw new NoSuchRequestHandlingMethodException("(ao "+action+")", this.clazz);
	}
	
	private Method findMethodName(Class[] hierarquia, String action) {
		for (Class class1 : hierarquia) {
			Method[] methods = class1.getMethods();
			for (Method method : methods) {
				if (method.getReturnType().equals(ModelAndView.class) || method.getReturnType().equals(void.class)) {
					Class[] params = method.getParameterTypes();
					// Check that the number and types of methods is correct.
					// We don't care about the declared exceptions.
					if (params.length >= 1 && params[0].equals(WebRequestContext.class)) {
						if(method.getName().equals(action)){
							return method;						
						}
					}
				}
			}
		}
		return null;
	}
	
	private Method findAction(Class[] hierarquia, String action) {
		for (Class class1 : hierarquia) {
			Method[] methods = class1.getMethods();
			for (Method method : methods) {
				if (method.getReturnType().equals(ModelAndView.class) || method.getReturnType().equals(void.class)) {
					Class[] params = method.getParameterTypes();
					// Check that the number and types of methods is correct.
					// We don't care about the declared exceptions.
					if (params.length >= 1 && params[0].equals(WebRequestContext.class)) {
						Action annotation = method.getAnnotation(Action.class);
						if(annotation != null){
							String value = annotation.value();
							if(value.equals(action)){
								return method;
							}
							
						}
					}
				}
			}
		}
		return null;
	}

	private Method findDefaultAction(Class[] hierarquia) {
		Method result = null;
		for (Class class1 : hierarquia) {
			Method[] methods = class1.getMethods();
			for (Method method : methods) {
				if (method.getReturnType().equals(ModelAndView.class) || method.getReturnType().equals(void.class)) {
					Class[] params = method.getParameterTypes();

					// Check that the number and types of methods is correct.
					// We don't care about the declared exceptions.
					if (params.length >= 1 && params[0].equals(WebRequestContext.class)) {
						if(method.getAnnotation(DefaultAction.class) != null){
							result = method;
						}
					}
				}
			}
		}
		return result;
	}

	private Class[] getHierarquia() {
		List<Class> hierarquia = new ArrayList<Class>();
		Class clazz = this.clazz;
		while(!MultiActionController.class.equals(clazz)){
			hierarquia.add(0, clazz);
			clazz = clazz.getSuperclass();
		}
		return hierarquia.toArray(new Class[hierarquia.size()]);
	}

	//public String getHandlerMethodName(HttpServletRequest request) throws NoSuchRequestHandlingMethodException {
	//	String actionParameter = request.getParameter(MultiActionController.ACTION_PARAMETER);
	//	return getHandlerMethodName(actionParameter);
	//}

//	public String getHandlerMethodName(String actionParameter) throws NoSuchRequestHandlingMethodException {
//		Collection<Method> methods = this.methods;
//		String methodName = getActionMethodName(actionParameter, methods);
//		if(methodName == null){
//			methodName = findMethodInAncessor(clazz.getSuperclass(), actionParameter);
//		}
//		if(methodName != null){
//			return methodName;
//		}
//		throw new NoSuchRequestHandlingMethodException("(ao "+actionParameter+")", this.clazz);
//	}

//	private String findMethodInAncessor(Class superclass, String actionParameter) {
//		if(MultiActionController.class.equals(superclass)){
//			return null;
//		}
//		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
//		Method[] methods = reflectionCache.getMethods(superclass);
//		String name = getActionMethodName(actionParameter, Arrays.asList(methods));
//		if(name == null){
//			return findMethodInAncessor(superclass.getSuperclass(), actionParameter);
//		}
//		return name;
//	}

//	private String getActionMethodName(String actionParameter, Collection<Method> methods) {
//		String methodName = null;
//		if(Util.strings.isEmpty(actionParameter)){
//			//procurar o mtodo com anotacao @DefaultAction
//			//TODO JOGAR EXECAO SE TIVER MAIS DE UM MTODO DEFAULT
//			//TODO JOGAR INICIALIZACAO PARA O CONSTRUTOR
//			for (Method method : methods) {
//				if(method.getAnnotation(DefaultAction.class)!=null){
//					methodName = method.getName();
//				}
//			}
//		} else {
//			//procurar mtodos com @Action ou @Actions
//			for (Method method : methods) {
//				Action annotation = method.getAnnotation(Action.class);
//				if(annotation!=null && annotation.value().equals(actionParameter)){
//					methodName = method.getName();
//				}
//				Actions actions = method.getAnnotation(Actions.class);
//				if(actions != null){
//					for (Action action : actions.value()) {
//						if(action.value().equals(actionParameter)){
//							methodName = method.getName();
//						}
//					}
//				}
//			}
//			
//			//procurar mtodos com nome igual ao parametro
//			for (Method method : methods) {
//				if(method.getName().equals(actionParameter)){
//					methodName = method.getName();
//				}
//			}
//		}
//		return methodName;
//	}



}
