/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 23/03/2005
 *
 */
package br.com.linkcom.neo.controller;

import br.com.linkcom.neo.authorization.AuthorizationModule;
import br.com.linkcom.neo.core.standard.RequestContext;


/**
 * Localiza os ControlMapping
 * @author rogelgarcia
 */
public interface ControlMappingLocator {
	/**
	 * Retorna o controlMapping de determinado request
	 * Procura na URL qual controle  responsvel pela requisicao e retorna 
	 * um controlMapping com as informaoes do mapeamento do controle
	 * @param request
	 * @return
	 */
    public abstract ControlMapping getControlMapping(RequestContext request);
    /**
     * Retorna um controlMapping que est registrado em determinada path
     * @param path
     * @return
     */
	public ControlMapping getControlMapping(String path);
	
	/**
	 * Registra um mapeamento
	 * 
	 * @param path URL que ser respondida pelo controle
	 * @param authorizationModuleClass Classe do mdulo de autorizao que esse mapeamento utilizar
	 */
	public void registerMapping(String path, Class<? extends AuthorizationModule> authorizationModuleClass);

	public String[] getRegisteredPaths();
}