/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */

package br.com.linkcom.neo.controller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

import br.com.linkcom.neo.authorization.AuthorizationModule;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;

/**
 * @author rogelgarcia
 * @since 20/10/2005
 * @version 1.0
 */
public class AnnotationsHandlerMapping extends AbstractUrlHandlerMapping {
	
	private static final Log log = LogFactory.getLog(AnnotationsHandlerMapping.class);

	protected String[] annotatedBeans = new String[0];
	protected String module = null;
	
	protected boolean registerWithFullUrl = false;
	
	public boolean isRegisterWithFullUrl() {
		return registerWithFullUrl;
	}

	public void setRegisterWithFullUrl(boolean registerWithFullUrl) {
		this.registerWithFullUrl = registerWithFullUrl;
	}

	public String[] getAnnotatedBeans() {
		return annotatedBeans;
	}

	public void setAnnotatedBeans(String[] annotatedBeans) {
		this.annotatedBeans = annotatedBeans;
		
	}

	public void initApplicationContext() throws BeansException {
	
		
		//procurar os Annotated Beans
		WebApplicationContext applicationContext = NeoWeb.getWebApplicationContext(getServletContext());
		Class<?>[] classesWithAnnotation = applicationContext.getClassManager().getClassesWithAnnotation(Controller.class);
		
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		log.info("Inicializando configurao dos Controllers para o modulo: "+getModule());
		for (Class<?> clazz : classesWithAnnotation) {
			Controller controller = reflectionCache.getAnnotation(clazz, Controller.class);
			
			String beanName = Util.beans.getName(clazz, applicationContext.getConfig().getBeanRegisters());
			
			if(beanName == null){
				beanName = Util.strings.uncaptalize(clazz.getSimpleName());
			}
			
			String[] paths = controller.path();
			for (int i = 0; i < paths.length; i++) {
				String path = paths[i];
				if(!path.startsWith("/")){
					path = '/'+path;
				}
				if(!path.startsWith(getModule())){
					continue;
				}
				Class<? extends AuthorizationModule> authorizationModuleClass = controller.authorizationModule();
				
				log.debug("Registrando "+path+" ("+clazz.getName()+")");
				applicationContext.getConfig().getControlMappingLocator().registerMapping(path, authorizationModuleClass);
				
				if(!registerWithFullUrl){
					path = path.substring(path.substring(1).indexOf('/')+1);
				}
					
				registerHandler(path, beanName);				
			}
		}
		
	}

	public String getModule() {
		if(module == null){
			throw new RuntimeException("A propriedade module da classe "+AnnotationsHandlerMapping.class.getName()+" no foi configurada. " +
					"Essa propriedade  o path do mdulo comeando com '/'. ex.: /moduloAcademico");
		}
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}


}
