/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.classmanager;

import java.io.File;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * @author rogelgarcia
 * @since 03/10/2005
 */
public class FileClassRegister {

	private static Log log = LogFactory.getLog(FileClassRegister.class);
	
	private static ClassManager classManager;
	
	private FileClassRegister(){
		
	}
	
	
	public static ClassManager getClassManager(File file) throws IOException{
		if(classManager == null){
			long x = System.currentTimeMillis();
			classManager = new ClassManagerImpl();
			String path = file.getAbsolutePath();
			String[] classesInPackage = ClassLocator.getClassesNameInPackage(path, File.separator);
			
			for (String name : classesInPackage) {
				try {
					classManager.registerClass(Class.forName(name));
				} catch (ClassNotFoundException e) {
					// se a classe nao for encontrada, nao fazer nada
				}
			}				
			x = System.currentTimeMillis() - x;
			log.debug("Classes registradas em "+x+" milisegundos");
		}
		return classManager;
	}
}
