/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.classmanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * @author rogelgarcia
 * @since 05/10/2005
 * @version 1.0
 */
public class ClassRegister {
	
	private static Log log = LogFactory.getLog(ClassRegister.class);
	
	private static ClassManager classManager;
	
	private ClassRegister(){
		
	}
	
	public static ClassManager getClassManager() throws IOException{
		if(classManager == null){
			long x = System.currentTimeMillis();
			classManager = new ClassManagerImpl();
			
			String basePath = ClassLoader.getSystemResource("").toExternalForm();
			basePath = basePath.substring(basePath.indexOf('/'));
			if(basePath.startsWith("/C:")){
				basePath = basePath.substring(1);
			}
			File file = new File(basePath);
			List<String> classNames = new ArrayList<String>();
			findClassesFiles(file.listFiles(), classNames, basePath);
			
			//List<Class<?>> classes = new ArrayList<Class<?>>();
			for (String name : classNames) {
				try {
					classManager.registerClass(Class.forName(name));
				} catch (ClassNotFoundException e) {
					// se a classe nao for encontrada, nao fazer nada
					e.printStackTrace();
				}
			}
			
			x = System.currentTimeMillis() - x;
			log.debug("Classes registradas em "+x+" milisegundos");
		}
		return classManager;
	}

	private static void findClassesFiles(File[] dir, List<String> classes, String basePath) throws IOException {
		for (File file : dir) {
			if(file.isFile()){
				String path = file.getPath();
				if(path.endsWith(".class")){
					basePath = basePath.replace("/", File.separator);
					String classFileName = path.replace(basePath, "");
					String className = classFileName.substring(0, classFileName.length() - ".class".length());
					className = className.replace(File.separatorChar,'.');
					classes.add(className);
				}
			} else if (file.isDirectory()){
				if(!file.getAbsolutePath().contains("linkcom"+File.separator+"neo"))
				findClassesFiles(file.listFiles(), classes, basePath);
			}
		}
	}
	
}
