/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.classmanager;


/**
 * O ClassManager funciona como um repositrio de classes.<BR>
 *  como um filtro para classes, voce determina que tipo de classe deseja e o ClassManger
 * retorna todas as classes com aquelas caractersticas.<BR>
 * Ex.: Voc registra uma classe A que extende a classe B. Mais tarde voc pode pedir todas as 
 * classes que so do tipo B, o classManager ir retornar a classe A.<BR> 
 *  possivel tambm criar familias de classes. Uma familia  um grupo de classes ou 
 * anotaes. Se determinada classe X for uma subclasse de uma das classes da familia Y ou 
 * tiver uma anotaao que fizer parte da familia Y, 
 * podemos dizer que a classe X faz parte da famlia Y. <BR>
 * 
 * O classManager no procura as classes no classPath. As classes retornadas nas pesquisas devem ter 
 * sido previamente registradas!
 * 
 * @author rogelgarcia
 */
public interface ClassManager {
	

	/**
	 * Procura todas as classes
	 * @return todas as classes encontradas
	 */
	Class<?>[] getAllClasses();
	
	/**
	 * Procura todas as classes em determinado pacote
	 * @param pacote pacote onde devem ser procuradas as classes (utilizar . (ponto) como separador)
	 * @return classes encontradas
	 */
	Class<?>[] getAllClassesFromPackage(String pacote);

	/**
	 * Procura as classes que so subtipo da classe fornecida
	 * @param <T> Tipo da classe
	 * @param type Classe que deve ser procurada
	 * @return Classes do mesmo tipo da classe fornecida
	 */
	Class<?>[] getAllClassesOfType(Class<?> type);
	
	/**
	 * Retorna todas as classes que possuem determinada anotao
	 * @param annotationType Anotao a ser procurada
	 * @return Classes com a anotao fornecida
	 */
	Class<?>[] getClassesWithAnnotation(Class<?> annotationType);

	/**
	 * Registra uma classe nesse classManager
	 * @param clazz
	 */
	void registerClass(Class<?> clazz);
	
}
