/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.classmanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ClassLocator {

	/**
	 * Procura as classes a partir do diretrio base e pacote
	 * @param baseDir Diretrio raiz do classPath, deve terminar sem o File.separator
	 * @param pack Diretrio do pacote base. Deve iniciar com File.separator
	 * @return Lista de classes encontrados
	 * @throws IOException 
	 */
	public static String[] getClassesNameInPackage(String baseDir, String pack) throws IOException{
		List<String> classes = new ArrayList<String>();
		int baseLenght = new File(baseDir).getCanonicalPath().length();
		File file = new File(baseDir+pack);
		fillList(classes, baseLenght, file);
		return classes.toArray(new String[classes.size()]);
	}

	private static void fillList(List<String> classes, int baseLenght, File file) throws IOException {
		File[] arquivos = file.listFiles();
		for (File arquivo : arquivos) {
			if (arquivo.isFile()) {
				String canonicalPath = arquivo.getCanonicalPath();
				if (canonicalPath.endsWith(".class")) {
					String className = canonicalPath.substring(baseLenght+1);
					className = className.substring(0, className.length() - ".class".length());
					classes.add(className.replace(File.separatorChar, '.'));
				}
			} else {
				fillList(classes, baseLenght, arquivo);
			}
		}
	}
	
	public static void main(String[] args) throws IOException {
		String[] classesInPackage = ClassLocator.getClassesNameInPackage("../framework2/bin", File.separator);
		for (String string : classesInPackage) {
			System.out.println(string);
		}
	}
}


