/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.util.List;

import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/**
 * Interface que define um registrador de beans. 
 * Um registrador de beans recebe uma lista de beans de determinado tipo
 * especificadas para poder registrar no factory do Spring.
 * 
 * @author rogelgarcia
 * @since 11/04/2007
 * @version 1.1
 */
public interface TypeBeanRegister {

	/**
	 * Retorna o tipo de classe que esse registrador consegue registrar
	 * @return
	 */
	Class getBeanClass(); 
	
	/**
	 * Retorna o nome que foi registrado o bean
	 */
	String getName(Class<?> clazz);
	
	/**
	 * Registra os beans anotados na factory
	 * @param annotatedClasses
	 * @param beanFactory
	 */
	void registerBeans(List<Class<?>> classes, DefaultListableBeanFactory beanFactory);

}
