/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import br.com.linkcom.neo.util.Util;

/**
 * @author rogelgarcia
 * @since 23/01/2006
 * @version 1.1
 */
public class PropertyDescriptorImpl implements PropertyDescriptor {

	private PropertyInfo propertyInfo;
	private BeanDescriptorImpl<?> beanDescriptor;

	public PropertyDescriptorImpl(BeanDescriptorImpl<?> beanDescriptorImpl, String propertyName) {
		//TODO TESTAR PARA VER SE ACHA PROPRIEDADES NAS CLASSES SUPERIORES. SE NAO ACHAR. TENTAR PROCURAR NAS CLASSES SUPERIORES
		propertyInfo = beanDescriptorImpl.getBeanWrapper().getPropertyInfo(propertyName);
		this.beanDescriptor = beanDescriptorImpl;
	}

	public String getPropertyName() {
		return propertyInfo.getPropertyName();
	}

	private String displayName;

	public String getDisplayName() {
		if (displayName == null) {
			displayName = DisplayNameUtil.getDisplayName(propertyInfo.ownerType, 
					Util.beans.getPropertyFromGetter(propertyInfo.getLastPropertyGetterName()),
					propertyInfo.annotations);
		}
		return displayName;
	}

	public Annotation[] getAnnotations() {
		return propertyInfo.getAnnotations();
	}

	public Type getType() {
		return propertyInfo.getType();
	}

	public Object getValue() {
		return propertyInfo.getValue();
	}

	public PropertyInfo getPropertyInfo() {
		return propertyInfo;
	}

	public BeanDescriptor<?> getBeanDescriptor() {
		return beanDescriptor;
	}

}
