/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.lang.reflect.Constructor;

import javax.servlet.jsp.PageContext;

import br.com.linkcom.neo.bean.editors.ValueBasedPropertyEditor;
import br.com.linkcom.neo.controller.ExtendedBeanWrapper;

public class PageContextIndexResolver implements IndexValueResolver {
	
	private PageContext pageContext;

	public PageContextIndexResolver(PageContext pageContext){
		if(pageContext == null){
			throw new NullPointerException();
		}
		this.pageContext = pageContext;
	}

	@SuppressWarnings("unchecked")
	public <E> E resolveName(String index, Class<E> requiredClass) {
		if(index.startsWith("'")){
			index = index.substring(1, index.length()-1);
			return (E) new ExtendedBeanWrapper().doTypeConversionIfNecessary(index, requiredClass);
		}
		if(index.equals("<null>")||index.matches("\\w*((\\.\\w*)*)\\[((.)*)\\]")){
			ValueBasedPropertyEditor propertyEditor = new ValueBasedPropertyEditor();
			propertyEditor.setAsText(index);
			return (E) propertyEditor.getValue();
		}
		if(Number.class.isAssignableFrom(requiredClass)){
			try {
				Constructor constructor = requiredClass.getConstructor(String.class);
				Object number = constructor.newInstance(index);
				return (E) number;
			} catch (Exception e) {
				//return index;
			}
		}

		Object findAttribute = pageContext.findAttribute(index);
		if(findAttribute == null){
			if(String.class.isAssignableFrom(requiredClass)) {
				return (E)index;
			}
			return null;
		}
		if(requiredClass.isAssignableFrom(findAttribute.getClass())){
			return (E) findAttribute;
		}
		return (E) new ExtendedBeanWrapper().doTypeConversionIfNecessary(findAttribute, requiredClass);
	}

}
