/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.lang.reflect.Constructor;

import br.com.linkcom.neo.bean.editors.ValueBasedPropertyEditor;

/**
 * @author rogelgarcia
 * @since 23/01/2006
 * @version 1.1
 */
public class IndexValueResolverImpl implements IndexValueResolver {

	@SuppressWarnings("unchecked")
	public <E> E resolveName(String index, Class<E> requiredClass) {
		if(index.equals("<null>")||index.matches("\\w*((\\.\\w*)*)\\[((.)*)\\]")){
			ValueBasedPropertyEditor propertyEditor = new ValueBasedPropertyEditor();
			propertyEditor.setAsText(index);
			return (E) propertyEditor.getValue();
		}
		if(Number.class.isAssignableFrom(requiredClass)){
			try {
				Constructor constructor = requiredClass.getConstructor(String.class);
				Object number = constructor.newInstance(index);
				return (E) number;
			} catch (Exception e) {
				//return index;
			}
		}
		if(Object.class.isAssignableFrom(requiredClass)){
			if("d".equals(index)){
				return (E) new Integer(0);
			}
			if("f".equals(index)){
				return (E) new Integer(1);
			}
		}
		if(String.class.isAssignableFrom(requiredClass)) {
			return (E)index;
		}
		return null;
	}

}
