/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;


public class EntityBean {
	
	
	protected BeanDescriptor getBeanDescriptor(Object o){
		BeanDescriptorFactoryImpl beanDescriptorFactoryImpl = new BeanDescriptorFactoryImpl();
		return beanDescriptorFactoryImpl.createBeanDescriptor(o);
	}

	@Override
	public boolean equals(Object obj) {
		if(obj == null || !this.getClass().equals(obj.getClass())){
			return false;
		}
		
		Object thisId = getBeanDescriptor(this).getId();
		Object thatId = getBeanDescriptor(obj).getId();
		if(thisId == null){
			return false;
		}
		return thisId.equals(thatId);
	}

	@Override
	public int hashCode() {
		Object thisId = getBeanDescriptor(this).getId();
		if(thisId == null){
			return 1;
		}
		return thisId.hashCode();
	}

	@SuppressWarnings("unchecked")
	@Override
	public String toString() {
		BeanDescriptor<EntityBean> beanDescriptor = getBeanDescriptor(this);
		return this.getClass().getSimpleName()+"["+beanDescriptor.getIdPropertyName()+"="+beanDescriptor.getId()+", "
				+ beanDescriptor.getDescriptionPropertyName()+"="+beanDescriptor.getDescription()+"]";
	}

	
}
