/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.lang.annotation.Annotation;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

import br.com.linkcom.neo.bean.annotation.Bean;
import br.com.linkcom.neo.bean.annotation.ServiceBean;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;

/**
 * @author rogelgarcia
 * @since 20/10/2005
 * @version 1.0
 */
public class BeanRegisterService extends BeanRegisterBean {
	@Override
	public Class<? extends Annotation> getAnnotationClass() {
		return ServiceBean.class;
	}

	@Override
	public String getName(Class<?> clazz) {
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		ServiceBean genericService = reflectionCache.getAnnotation(clazz, ServiceBean.class);
		return getBeanName(clazz, genericService.bean());
	}
	
	@Override
	protected void registerBean(DefaultListableBeanFactory beanFactory, Class<?> class1) {
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		ServiceBean genericService = reflectionCache.getAnnotation(class1, ServiceBean.class);
		/* TODO FAZER VALIDACAO
		if(!GenericService.class.isAssignableFrom(class1)){
			throw new RuntimeException("A classe "+class1.getName()+" declarou a anotao "
					+ServiceBean.class.getSimpleName()+" e no extende "
					+GenericService.class.getName()+". Somente classes que extenderem "
					+GenericService.class.getName()+" podem declarar a anotao "
					+ServiceBean.class.getSimpleName());
		}
		*/
		registerBean(beanFactory, class1, genericService.bean());
	}

	@Override
	protected MutablePropertyValues createPropertyValues(Class<?> class1, Bean bean) {
		MutablePropertyValues mutablePropertyValues = super.createPropertyValues(class1, bean);
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		ServiceBean genericService = reflectionCache.getAnnotation(class1, ServiceBean.class);
		if(StringUtils.isEmpty(genericService.genericDAORef())){
			String sn = StringUtils.uncapitalize(class1.getSimpleName());
			sn = sn.substring(0, sn.length()-"Service".length());
			sn += "DAO";
			mutablePropertyValues.addPropertyValue("genericDAO", new RuntimeBeanReference(sn));
		} else {
			mutablePropertyValues.addPropertyValue("genericDAO", genericService.genericDAORef());
		}
		return mutablePropertyValues;
	}
	
}
