/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.lang.annotation.Annotation;

import org.springframework.beans.factory.support.DefaultListableBeanFactory;

import br.com.linkcom.neo.bean.annotation.Bean;
import br.com.linkcom.neo.bean.annotation.DAOBean;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;

/**
 * @author rogelgarcia
 * @since 20/10/2005
 * @version 1.0
 */
public class BeanRegisterDao extends BeanRegisterBean {

	@Override
	public Class<? extends Annotation> getAnnotationClass() {
		return DAOBean.class;
	}
	
	@Override
	public String getName(Class<?> clazz) {
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		Bean bean = reflectionCache.getAnnotation(clazz, DAOBean.class).bean();
		return getBeanName(clazz, bean);
	}

	@Override
	protected void registerBean(DefaultListableBeanFactory beanFactory, Class<?> class1) {
		/* TODO FAZER VALIDACAO
		if(!GenericDAO.class.isAssignableFrom(class1)){
			throw new RuntimeException("A classe "+class1.getName()+" declarou a anotao "
					+DAOBean.class.getSimpleName()+" e no extende "
					+GenericDAO.class.getName()+". Somente classes que extenderem "
					+GenericDAO.class.getName()+" podem declarar a anotao "
					+DAOBean.class.getSimpleName());
		}
		*/
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		Bean bean = reflectionCache.getAnnotation(class1, DAOBean.class).bean();
		registerBean(beanFactory, class1, bean);
	}


}
