/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.lang.annotation.Annotation;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

import br.com.linkcom.neo.bean.annotation.Bean;
import br.com.linkcom.neo.bean.annotation.CrudBean;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;

/**
 * @author rogelgarcia
 * @since 20/10/2005
 * @version 1.0
 */
public class BeanRegisterCrud extends BeanRegisterBean {
	@Override
	public Class<? extends Annotation> getAnnotationClass() {
		return CrudBean.class;
	}

	@Override
	public String getName(Class<?> clazz) {
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		CrudBean genericCrud = reflectionCache.getAnnotation(clazz, CrudBean.class);
		return getBeanName(clazz, genericCrud.bean());
	}

	@Override
	protected void registerBean(DefaultListableBeanFactory beanFactory, Class<?> class1) {
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		CrudBean genericCrud = reflectionCache.getAnnotation(class1, CrudBean.class);
		/* TODO FAZER VALIDACAO
		if(!GenericCrud.class.isAssignableFrom(class1)){
			throw new RuntimeException("A classe "+class1.getName()+" declarou a anotao "
					+CrudBean.class.getSimpleName()+" e no extende "
					+GenericCrud.class.getName()+". Somente classes que extenderem "
					+GenericCrud.class.getName()+" podem declarar a anotao "
					+CrudBean.class.getSimpleName());
		}
		*/
		registerBean(beanFactory, class1, genericCrud.bean());
	}

	@Override
	protected MutablePropertyValues createPropertyValues(Class<?> class1, Bean bean) {
		MutablePropertyValues mutablePropertyValues = super.createPropertyValues(class1, bean);
		ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
		CrudBean genericCrud = reflectionCache.getAnnotation(class1, CrudBean.class);
		if(StringUtils.isEmpty(genericCrud.genericServiceRef())){
			String sn = StringUtils.uncapitalize(class1.getSimpleName());
			sn = sn.substring(0, sn.length()-"Crud".length());
			sn += "Service";
			mutablePropertyValues.addPropertyValue("genericService", new RuntimeBeanReference(sn));
		} else {
			mutablePropertyValues.addPropertyValue("genericService", new RuntimeBeanReference(genericCrud.genericServiceRef()));
		}
		return mutablePropertyValues;
	}
}
