/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.bean;

import java.lang.annotation.Annotation;
import java.util.List;

import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/**
 * Interface que define um registrador de beans. 
 * Um registrador de beans recebe uma lista de beans com annotaes 
 * especificadas para poder registrar no factory do Spring.
 * 
 * @author rogelgarcia
 * @since 21/01/2006
 * @version 1.1
 */
public interface AnnotatedBeanRegister {
	
	/**
	 * Retorna a classe de anotao que esse registrador consegue registrar
	 * @return
	 */
	Class<? extends Annotation> getAnnotationClass(); 
	
	/**
	 * Retorna o nome que foi registrado o bean
	 */
	String getName(Class<?> clazz);
	
	/**
	 * Registra os beans anotados na factory
	 * @param annotatedClasses
	 * @param beanFactory
	 */
	void registerBeans(List<Class<?>> annotatedClasses, DefaultListableBeanFactory beanFactory);
	
}
