/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 22/03/2005
 *
 */
package br.com.linkcom.neo.authorization.impl;

import java.security.Principal;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.Role;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.authorization.UserLocator;
import br.com.linkcom.neo.core.standard.RequestContext;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.view.menu.MenuTag;


/**
 * 
 * Implementacao da interface para localizar os Users
 * 
 * @author rogelgarcia
 */
public class UserLocatorImpl implements UserLocator{
    
	protected AuthorizationDAO authorizationDAO;

    public AuthorizationDAO getAuthorizationDAO() {
		return authorizationDAO;
	}

	public void setAuthorizationDAO(AuthorizationDAO authorizationDAO) {
		this.authorizationDAO = authorizationDAO;
	}

	public User getUser(RequestContext request) {
        User user = request.getUser();
        if(user == null){
            Principal userPrincipal = ((WebRequestContext)request).getUserPrincipal();
            if (userPrincipal!=null) {
                String username = userPrincipal.getName();
                if (username != null) {
                    user = authorizationDAO.findUserByLogin(username);
                    //limpar cache dos menus
                    if(request instanceof WebRequestContext){
                    	((WebRequestContext)request).getSession().setAttribute(MenuTag.MENU_CACHE_MAP, null);
                    }
                    if (user == null) {    
                        throw new NeoException(
                                "Usurio no encontrado no banco de dados: "
                                        + username);
                    }
                } else {
                    // O CDIGO PROVAVELMENTE NO CHEGAR AQUI
                    // userPrincipal.getName() no deve retornar null
                    throw new RuntimeException("Erro inesperado: Algoritmo invlido em UserLocatorImpl");
                }
            } else {
                //NINGUEM LOGADO
                user = null;
            }
            //TODO TROCAR PARA DEFAULTREQUESTCONTEXT QUANDO TIVER
            ((DefaultWebRequestContext)request).setUser(user);
        }
        
        return user;
    }

	public void loadPermissions(WebRequestContext requestContext) {
		if (requestContext.getSession().getAttribute("NEO_LOADPERMISSIONS")==null) {
			User user = getUser(requestContext);
			if (user != null) {
				Role[] findUserRoles = authorizationDAO.findUserRoles(user);
				for (Role role : findUserRoles) {
					requestContext.getSession().setAttribute("PAPEL_" + role.getName().toUpperCase(), true);
				}
				requestContext.getSession().setAttribute("NEO_LOADPERMISSIONS", true);
			}
		}
	}
}
