/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 24/03/2005
 *
 */
package br.com.linkcom.neo.authorization.impl;

import br.com.linkcom.neo.authorization.Role;

/**
 * Representa um papel no sistema
 * Um grupo de usurios
 * @author rogelgarcia
 */
public class RoleImpl implements Role {

    protected String name;
    protected String description;
    
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
	public int hashCode() {
		if (name == null) {
            return 0;
        }
        return name.hashCode();
    }
    
    @Override
    public boolean equals(Object obj) {
        if(obj == null )return false;
        if(RoleImpl.class.isAssignableFrom(obj.getClass())){
            RoleImpl that = (RoleImpl)obj;
            return this.getName().equals(that.getName());
        }
        return false;
    }

}
