/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 18/03/2005
 *
 */
package br.com.linkcom.neo.authorization.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.PermissionPK;
import br.com.linkcom.neo.authorization.Role;

/**
 * Permissao de determinado Role para determinado control no sistema
 * @author rogelgarcia
 */
public class PermissionImpl implements Permission {
    
	protected Map<String, String> permissionMap;
    
    //private String controlName;
    //private Role role;
    protected PermissionPK permissionPK;
    protected String permissionString;
    
    /* (non-Javadoc)
	 * @see br.com.linkcom.neo.authorization.Permission#getControlName()
	 */
    public String getControlname() {
        if(permissionPK!=null){
            return permissionPK.getControlName();
        }
        return null;
    }
    /* (non-Javadoc)
	 * @see br.com.linkcom.neo.authorization.Permission#getRole()
	 */
    public Role getRole() {
        if(permissionPK!=null){
            return permissionPK.getRole();
        }
        return null;
    }

    public void setPermissionMap(Map<String, String> map){
        this.permissionMap = map;
        StringBuilder builder = new StringBuilder();
        for (Iterator<String> iter = map.keySet().iterator(); iter.hasNext();) {
			String id = (String) iter.next();
			builder.append(id);
			builder.append("=");
			builder.append(map.get(id));
			if(iter.hasNext()){
				builder.append(";");
			}
		}
        this.permissionString = builder.toString();
    }
    
    public String getPermissionvalue(String id){
        return (String)permissionMap.get(id);
    }
    public PermissionPK getPermissionPK() {
        return permissionPK;
    }
    public void setPermissionPK(PermissionPK permissionPK) {
        this.permissionPK = permissionPK;
    }
    public String getPermissionString() {
        return permissionString;
    }
    public void setPermissionString(String permissionString) {
        this.permissionString = permissionString;
        permissionMap = new HashMap<String, String>();
        String[] permissoes = permissionString.split(";");
        for (int i = 0; i < permissoes.length; i++) {
            String[] map = permissoes[i].split("=");
            String key = map[0];
            String value = map[1];
            permissionMap.put(key, value);
        }
    }
    
    public String toString() {
        return new ToStringBuilder(this)
        	.append("role", getRole().getName())
        	//.append("controlName", getControlname())
        	.append("permissionString", permissionString)
        	.toString();
    }
	/* (non-Javadoc)
	 * @see br.com.linkcom.neo.authorization.Permission#getPermissionMap()
	 */
	public Map<String, String> getPermissionmap() {
		return permissionMap;
	}
}
