/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 22/03/2005
 *
 */
package br.com.linkcom.neo.authorization.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import br.com.linkcom.neo.authorization.AuthorizationModule;
import br.com.linkcom.neo.controller.ControlMapping;
import br.com.linkcom.neo.controller.ControlMappingLocator;
import br.com.linkcom.neo.core.standard.RequestContext;
import br.com.linkcom.neo.exception.NeoException;



/**
 * Implementacao da interface para localizar os ControlMappings
 * @author rogelgarcia
 */
public class ControlMappingLocatorImpl implements ControlMappingLocator {


	protected Map<String, Class<? extends AuthorizationModule>> mapPathAuthorizationModule = new HashMap<String, Class<? extends AuthorizationModule>>();


	public ControlMapping getControlMapping(RequestContext request){

        ControlMapping controlMapping = null;
        
        String path = request.getRequestQuery();
        
        controlMapping = getControlMapping(path);

        return controlMapping;
    }



	public ControlMapping getControlMapping(String path) {
		ControlMapping controlMapping;
		AuthorizationModule authorizationModule = getAuthorizationModule(path);
		controlMapping = new ControlMapping();
		controlMapping.setAuthorizationModule(authorizationModule);
		//controlMapping.setPath(path);
        controlMapping.setName(path);
		return controlMapping;
	}



	public AuthorizationModule getAuthorizationModule(String path) {

		AuthorizationModule authorizationModule = null;

		// tentar achar atrves dos handlerMappings configurados no SPRING
		// utilizando annotations
		// a configurao de autorizao via annotations s  possvel
		// se o handler mapping usado for o especificado pelo framework
		Class<? extends AuthorizationModule> clazz = mapPathAuthorizationModule.get(path);
		if (clazz != null) {
			try {
				authorizationModule = clazz.newInstance();
			} catch (Exception e) {
				throw new NeoException(e);
			} 
		}

		return authorizationModule;
	}

	
	public void registerMapping(String path, Class<? extends AuthorizationModule> authorizationModule){
		mapPathAuthorizationModule.put(path, authorizationModule);
	}

	public String[] getRegisteredPaths() {
		Set<String> keySet = mapPathAuthorizationModule.keySet();
		return keySet.toArray(new String[keySet.size()]);
	}

}
