/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.authorization.impl;


import java.util.Map;
import java.util.Set;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.Guest;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.Role;
import br.com.linkcom.neo.authorization.User;

/**
 * Implementao padro para aplicaes que no utilizam autorizao.
 * Essa implementao suporta os modulos de autorizao padro do NEO. 
 * Ele d permisso para qualquer tela para qualquer usurio.
 * O usuario logado sempre ser da classe Guest.
 * @author rogelgarcia
 * @since 22/01/2006
 * @version 1.1
 */
public class AuthorizationDAOImpl implements AuthorizationDAO {

	public User findUserByLogin(String login) {
		Guest guest = new Guest();
		guest.setLogin(login);
		return guest;
	}

	public Role[] findUserRoles(User user) {
		return new Role[0];
	}

	public Permission findPermission(Role role, String controlName) {
		return null;
	}

	public Permission savePermission(final String controlName, final Role role, final Map<String, String> permissionMap) {
		return new Permission(){

			@SuppressWarnings("unused")
			public String getControlname() {
				return controlName;
			}

			public Role getRole() {
				return role;
			}

			public Map<String, String> getPermissionmap() {
				Set<String> keySet = permissionMap.keySet();
				for (String string : keySet) {
					permissionMap.put(string, "true");
				}
				return permissionMap;
			}

			public String getPermissionvalue(String id) {
				return "true";
			}};
	}

	public Role[] findAllRoles() {
		return new Role[0];
	}

}
