/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 24/03/2005
 *
 */
package br.com.linkcom.neo.authorization.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.PermissionPK;
import br.com.linkcom.neo.authorization.Role;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.exception.AuthorizationException;
import br.com.linkcom.neo.exception.ConfigurationException;


/**
 * Implementao da interface para localizacao de dados persistentes
 * @author rogelgarcia
 */
public class AuthorizationDAOHibernate implements AuthorizationDAO {
	

	static Log log = LogFactory.getLog(AuthorizationDAOHibernate.class);
    
	protected String userQuery;
	protected String rolesQuery;
	protected String permissionQuery;
	
	protected HibernateTemplate hibernateTemplate;
	
	public HibernateTemplate getHibernateTemplate() {
		return hibernateTemplate;
	}

	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	
	public String getPermissionQuery() {
		return permissionQuery;
	}

	public String getRolesQuery() {
		return rolesQuery;
	}

	public String getUserQuery() {
		return userQuery;
	}

	public void setPermissionQuery(String permissionQuery) {
		this.permissionQuery = permissionQuery;
	}

	public void setRolesQuery(String rolesQuery) {
		this.rolesQuery = rolesQuery;
	}

	public void setUserQuery(String userQuery) {
		this.userQuery = userQuery;
	}

    @SuppressWarnings("unchecked")
    public User findUserByLogin(String login) {
		if (userQuery == null) {
			throw new ConfigurationException("Propriedade userQuery no fornecida");
		}
        try {
			List find = hibernateTemplate.find(userQuery, login);
			return find.size() == 0 ? null : (User) find.get(0);
		} catch (Exception e) {
			throw new AuthorizationException("Problema ao excecutar query na classe "+AuthorizationDAOHibernate.class.getName()+". Query: "+userQuery, e);
		}
    }

    @SuppressWarnings("unchecked")
    public Role[] findUserRoles(User user) {
		if (rolesQuery == null) {
			throw new ConfigurationException("Propriedade userQuery no fornecida");
		}
        try {
			List find = hibernateTemplate.find(rolesQuery, user);
			return (Role[]) find.toArray(new Role[find.size()]);
		} catch (Exception e) {
			throw new AuthorizationException("Problema ao excecutar query na classe "+AuthorizationDAOHibernate.class.getName()+". Query: "+rolesQuery);
		}
    }

    @SuppressWarnings("unchecked")
    public Permission findPermission(Role role, String controlName) {
		if (permissionQuery == null) {
			throw new ConfigurationException("Propriedade userQuery no fornecida");
		}
        try {
			List find = hibernateTemplate.find(permissionQuery, new Object[] { role, controlName });
			return find.size() == 0 ? null : (Permission) find.get(0);
		} catch (Exception e) {
			throw new AuthorizationException("Problema ao excecutar query na classe "+AuthorizationDAOHibernate.class.getName()+". Query: "+permissionQuery);
		}
    }


	public Permission savePermission(String controlName, Role role, Map<String, String> permissionMap) {
		log.debug("savePermission controlName="+controlName+", role="+role.getName()+", permissionMap="+permissionMap);
		PermissionImpl permissionImpl = new PermissionImpl();
		PermissionPK permissionPK = new PermissionPK();
		permissionImpl.setPermissionPK(permissionPK);
		permissionPK.setControlName(controlName);
		permissionPK.setRole(role);
		permissionImpl.setPermissionMap(permissionMap);
		return permissionImpl;
	}

	@SuppressWarnings("unchecked")
	public Role[] findAllRoles() {
        try {
			List find = hibernateTemplate.find("from "+Role.class.getName());
			Object[] toArray = find.toArray(new Role[find.size()]);
			return (Role[]) toArray;
		} catch (Exception e) {
			throw new AuthorizationException("Problema ao excecutar query na classe "+AuthorizationDAOHibernate.class.getName()+". Query: from "+Role.class.getName());
		}
	}

}
