/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 18/03/2005
 *
 */
package br.com.linkcom.neo.authorization.crud;

import br.com.linkcom.neo.authorization.Authorization;
import br.com.linkcom.neo.authorization.Authorizer;
import br.com.linkcom.neo.controller.crud.AbstractCrudController;
import br.com.linkcom.neo.exception.AuthorizationException;

/**
 * @author rogelgarcia
 */
public class CrudAuthorizer implements Authorizer {

    protected static final String ACTION_CRIAR = AbstractCrudController.CRIAR;
    protected static final String ACTION_EDITAR = AbstractCrudController.EDITAR;
    protected static final String ACTION_SALVAR = AbstractCrudController.SALVAR;
    protected static final String ACTION_EXCLUIR = AbstractCrudController.EXCLUIR;
    protected static final String ACTION_ENTRADA = AbstractCrudController.ENTRADA;
    protected static final String ACTION_LISTAGEM = null;
    
    
    protected static final String METODO_CRIAR = "doCriar";
    protected static final String METODO_EDITAR = "doEditar";
    protected static final String METODO_SALVAR = "doSalvar";
    protected static final String METODO_EXCLUIR = "doExcluir";
    protected static final String METODO_ENTRADA = "doEntrada";
    
    private CrudAuthorizer(){}
    
    private static CrudAuthorizer instancia;
    
    public static CrudAuthorizer getInstance(){
        if(instancia == null){
            instancia = new CrudAuthorizer();
        }
        return instancia;
    }
    
    public boolean isAuthorized(String acao, Authorization autorizacao) {
        if(!(autorizacao instanceof CrudAuthorization)){
            throw new AuthorizationException("O tipo da autorizacao usada pela classe AutorizadorCrud deve ser do tipo " +
            		"AutorizacaoCrud");
        }
        CrudAuthorization autorizacaoCrud = (CrudAuthorization)autorizacao;
        if(acao==null || acao.equals("")  || acao.equals("listagem") || acao.equals("doListagem") || acao.equals("consultar") || acao.equals("doConsultar")){
            return autorizacaoCrud.canRead();
        } else {
            if(acao.equals(ACTION_CRIAR) || acao.equals(METODO_CRIAR)){
                return autorizacaoCrud.canCreate();
            } else if(acao.equals(ACTION_EDITAR) || acao.equals(METODO_EDITAR)){
                return autorizacaoCrud.canUpdate();
            } else if(acao.equals(ACTION_SALVAR) || acao.equals(ACTION_ENTRADA) || acao.equals(METODO_SALVAR) || acao.equals(METODO_ENTRADA)){
                return autorizacaoCrud.canCreate() || autorizacaoCrud.canUpdate();
            } else if(acao.equals(ACTION_EXCLUIR) || acao.equals(METODO_EXCLUIR)){
                return autorizacaoCrud.canDelete();
            }
        }
        
        return true;
    }

}
