/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 18/03/2005
 *
 */
package br.com.linkcom.neo.authorization.crud;

import br.com.linkcom.neo.authorization.Authorization;
import br.com.linkcom.neo.authorization.AuthorizationItem;
import br.com.linkcom.neo.authorization.AuthorizationModuleSupport;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.exception.InconsistencyException;


/**
 * @author rogelgarcia
 */
public class CrudAuthorizationModule extends AuthorizationModuleSupport {

    //public static final String ID_MODULO = "Crud";
    
    public static final String LISTAGENS_ENTRADA_DE_DADOS = "Listagens / Entrada de dados";
    
	protected static final String READ   = "read";
    protected static final String CREATE = "create";
    protected static final String UPDATE = "update";
    protected static final String DELETE = "delete";

    
    public CrudAuthorization createAuthorization(Permission[] permissoes) {
        boolean canCreate = false;
        boolean canRead   = false;
        boolean canUpdate = false;
        boolean canDelete = false;
        
        for (int i = 0; i < permissoes.length; i++) {
            Permission permissao = permissoes[i];
            try {
            	if(permissao == null){
            		throw new NullPointerException("permissao nula encontrada");
            	}
                if (!canCreate) {
                	String permissionvalue = permissao.getPermissionvalue(CREATE);
                	if(permissionvalue == null){
                		throw new IllegalArgumentException("Sem parmetro: "+CREATE);
                	}
					canCreate = permissionvalue.equals("true");
                }
                if (!canRead) {
                	String permissionvalue = permissao.getPermissionvalue(READ);
                	if(permissionvalue == null){
                		throw new IllegalArgumentException("Sem parmetro: "+READ);
                	}
					canRead = permissionvalue.equals("true");
                }
                if (!canUpdate) {
                	String permissionvalue = permissao.getPermissionvalue(UPDATE);
                	if(permissionvalue == null){
                		throw new IllegalArgumentException("Sem parmetro: "+UPDATE);
                	}
					canUpdate = permissionvalue.equals("true");
                }
                if (!canDelete) {
                	String permissionvalue = permissao.getPermissionvalue(DELETE);
                	if(permissionvalue == null){
                		throw new IllegalArgumentException("Sem parmetro: "+DELETE);
                	}
					canDelete = permissionvalue.equals("true");
                }
            } catch (IllegalArgumentException e) {
                throw new InconsistencyException("Inconsistencia no objeto Permission! " +
                		"Faltando algum dos parametros (create, read, update ou delete): "+permissao+"..."+e.getMessage());
            } catch (NullPointerException e) {
            	throw new InconsistencyException("NullPointerException inespereado no CRUDAuthorizationModule "+e.getMessage());
            }
        }

        CrudAuthorization autorizacao = new CrudAuthorization();
        autorizacao.setCreate(canCreate);
        autorizacao.setRead(canRead);
        autorizacao.setUpdate(canUpdate);
        autorizacao.setDelete(canDelete);
        return autorizacao;
    }

    public boolean isAuthorized(String acao, Authorization autorizacao) {
        return CrudAuthorizer.getInstance().isAuthorized(acao, autorizacao);
    }

    public AuthorizationItem[] getAuthorizationItens() {
        return new AuthorizationItem[]{
            new AuthorizationItem(READ, "ler", new String[]{"true","false"}),
            new AuthorizationItem(CREATE, "criar", new String[]{"true","false"}),
	        new AuthorizationItem(UPDATE, "editar", new String[]{"true","false"}),
	        new AuthorizationItem(DELETE, "excluir", new String[]{"true","false"})	        
        };
    }

	public String getAuthorizationGroupName() {
		return LISTAGENS_ENTRADA_DE_DADOS;
	}

}
