/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 30/03/2005
 *
 */
package br.com.linkcom.neo.authorization;

import java.io.Serializable;

import br.com.linkcom.neo.authorization.impl.PermissionImpl;

/**
 * @author rogelgarcia
 */
public class PermissionPK implements Serializable{
    /**
	 * 
	 */
	private static final long serialVersionUID = 3257854281154704441L;
	protected String controlName;
    protected Role role;
    public String getControlName() {
        return controlName;
    }
    public Role getRole() {
        return role;
    }
    public void setControlName(String controlName) {
        this.controlName = controlName;
    }
    public void setRole(Role role) {
        this.role = role;
    }
    public boolean equals(Object obj) {
        if(obj instanceof PermissionImpl){
            PermissionImpl that = (PermissionImpl) obj;
            return 
            	this.getControlName().equals(that.getControlname())&&
            	this.getRole().equals(that.getRole());
        }
        return false;
    }
    public int hashCode() {
        return super.hashCode();
    }
}
