/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 21/03/2005
 *
 */
package br.com.linkcom.neo.authorization;

import br.com.linkcom.neo.controller.ControlMapping;
import br.com.linkcom.neo.core.standard.RequestContext;



/**
 * Interface que define um localizador para as permissoes de determinado usuario no sistema
 * 
 * A classe no sistema que implementar essa interface, deve 
 * ter um parametro de contexto chamado LocalizadorPermissao
 * com o nome completo da classe como valor.
 * Essa interface  utilizada para verificar as permicoes de um determinado usuario 
 * para determinada acao 
 * @author rogelgarcia
 */
public interface PermissionLocator {
    
	/**
	 * Retorna as permissoes de determinado usurio para determinado controle
	 * @param usuario
	 * @param idControl
	 * @return
	 */
    public Permission[] getPermissions(RequestContext request, User usuario, ControlMapping idControl);
    
    
    public void clearCache();
}
