/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 18/03/2005
 *
 */
package br.com.linkcom.neo.authorization;


/**
 * O ModuloAutorizacao representa um tipo de autorizacao no sistema.
 * O ModuloAutorizacao define como  determinada autorizacao 
 * (quais ItemAutorizacao tem). E verifica se o usurio pode efetuar determinada 
 * acao no sistema. O Modulo pode utilizar um autorizador para verificar a autorizacao.
 * O Modulo tambm cria a Autorizacao de determinado usurio baseado em suas permissoes.
 * 
 * O ModuloAutorizacao deve especificar um pequeno contrato contendo as seguintes informaes:
 * 
 * Autorizacao: classe que representa uma autorizacao daquele modulo
 * Itens Autorizacao: quais items de autorizacao esse modulo possui
 * 
 * @author rogelgarcia
 */
public interface AuthorizationModule {
    
    /**
     * Cria uma autorizacao baseado nas permissoes. A classe da Autoricao criada  
     * definida pelo contrato do Modulo
     */
    public Authorization createAuthorization(Permission[] permissoes);
    
    /**
     * Verifica se o usurio  autorizado a efetuar determinada acao baseado nas permissoes que ele tem 
     * para determinado Control.  importante que s sejam fornecidas permissoes para o Control que o 
     * usurio estiver usando.
     */
    public boolean isAuthorized(String acao, Permission[] permissoes);
    
    
    /**
     * Verifica se o usurio  autorizado a efetuar determinada acao baseado na Autorizacao. 
     *  importante que essa autorizacao seje forjada com permissoes que  
     * sejam para o Control que o usurio estiver usando.
     */
    public boolean isAuthorized(String acao, Authorization autorizacao);
    
    /**
     * Retorna a lista de AuthorizationItem para esse Modulo
     */
    public AuthorizationItem[] getAuthorizationItens();
    
    /**
     * Retorna o nome do grupot desse authorization module. Authorizations module
     * com o mesmo Group Name sero agrupados no mesmo bloco na tela de autorizacao
     * @return
     */
    public String getAuthorizationGroupName();
    
}
