/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 18/03/2005
 *
 */
package br.com.linkcom.neo.authorization;

/**
 * Representa um item de autorizacao.
 * Num crud teriamos 4 items
 * Create, Read, Update, Delete
 * @author rogelgarcia
 */
public class AuthorizationItem {
    protected String id;
    protected String nome;
    protected String[] valores;
    protected String descricao;
    
    /**
     * Construtor bsico para um AuthorizationItem
     * @param id Identificador do item
     * @param nome Nome do item (display-name)
     * @param valores valores possveis para esse item
     */
    public AuthorizationItem(String id, String nome, String[] valores) {
        this.id = id;
        this.nome = nome;
        this.valores = valores;
    }
    
    public String getDescricao() {
        return descricao;
    }
    public String getId() {
        return id;
    }
    public String getNome() {
        return nome;
    }
    public String[] getValores() {
        return valores;
    }
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }
    public void setId(String id) {
        this.id = id;
    }
    public void setNome(String nome) {
        this.nome = nome;
    }
    public void setValores(String[] valores) {
        this.valores = valores;
    }

    /**
     *
     */

}
