/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 18/03/2005
 *
 */
package br.com.linkcom.neo.authorization;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import br.com.linkcom.neo.core.standard.ApplicationContext;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebRequestContext;


/**
 * Filtro para autorizacao no sistema
 * @author rogelgarcia
 */
public class AuthorizationFilter implements Filter {

    //private static final String ACTION_PARAMETER = ExtendedBaseController.ACTION_PARAMETER;
	
    public void init(FilterConfig config) throws ServletException {
    	config.getInitParameterNames();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;       
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        boolean isAuthorized = false;
		        
		HttpSession session = httpServletRequest.getSession();
		ServletContext context = session.getServletContext();

        ApplicationContext applicationContext = NeoWeb.getWebApplicationContext(context);
		WebRequestContext requestContext = NeoWeb.getRequestContext(httpServletRequest, httpServletResponse);
		
		AuthorizationManager manager = applicationContext.getAuthorizationManager();
		
		//verifica se o usurio tem autorizao .. esse mtodo salva a autorizao no escopo como Authorization.AUTHORIZATION_ATTRIBUTE
		isAuthorized = manager.isAutorized(requestContext);

		if(isAuthorized){
			manager.loadPermissions(requestContext);
            chain.doFilter(request, response);
		} else {
			((HttpServletResponse)response).sendError(HttpServletResponse.SC_FORBIDDEN);
		}
    }



    public void destroy() {
    }

}
