/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.authorization;

import java.util.Map;

/**
 * Interface que representa o acesso a dados de autorizacao do framework. 
 * Todos os dados persistentes que o framework necessitar so 
 * buscados atravs de uma classe que implementa essa interface 
 * @author rogelgarcia
 * @since 22/01/2006
 * @version 1.1
 */
public interface AuthorizationDAO {

	/**
	 * Retorna um usurio com determinado login
	 * @param login
	 * @return
	 */
    public User findUserByLogin(String login);
    
    /**
     * Procura todos os papeis que determinado usurio faz parte
     * @param user
     * @return
     */
    public Role[] findUserRoles(User user);
    
    /**
     * Acha uma determinada permissao de determinado papel em determinado controle
     * @param role
     * @param controlName
     * @return
     */
    public Permission findPermission(Role role, String controlName);
    
    /**
     * Salva ou atualiza uma permissao no banco para determinado controle, papel e permissoes
     * Retorna a permissao que foi salva no banco de dados
     * @param controlName
     * @param role
     * @param permissionMap
     * @return
     */
    public Permission savePermission(String controlName, Role role, Map<String, String> permissionMap);
    
    /**
     * Retorna todos os papis que existem no sistema
     * @return
     */
    public Role[] findAllRoles();
    
}
