/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
/*
 * Criado em 18/03/2005
 *
 */
package br.com.linkcom.neo.authorization;

/**
 * Representa a autorizacao de um usuario.
 * A classe que implementar essa interface deve 
 * ter mtodos do tipo canRead canWrite que retorna 
 * algum valor do tipo boolean indicando se o usurio 
 * pode ou no fazer algo no sistema para determinado 
 * control
 * @author rogelgarcia
 */
public interface Authorization {
    
    /**
     * Constante que define o nome do atributo da autorizacao
     * Sempre que o usurio pedir algum recurso  salvo, por um filtro, um objeto Autorizacao no request
     */
    public static final String AUTHORIZATION_ATTRIBUTE = "authorization";
}
