function atualizarCapitulos() {
	var as = document.getElementsByTagName("a");
	var cap = 0;
	for (var i = 0; i < as.length; i++) {
		var a = as[i];
		if (a.className == "tituloIndice") {
			cap++;
			a.innerHTML = "" + cap + " - " + a.innerHTML;
			a.setAttribute('capNum', cap);
		}
	}
}

function abreCapitulo(link) {
	var capituloAberto = document.getElementById('capituloAberto');
	capituloAberto.value = link.getAttribute('capNum');
	setTimeout('reduceFrameSize(210)', 30);
}

function reduceFrameSize(newSize){
	window.top.document.body.cols = newSize+",*";
	if(newSize > (navigator.appName.indexOf("Netscape")!= -1? 10 : 15)){
		newSize = newSize / 12 * 9;
		setTimeout('reduceFrameSize('+(newSize)+')', 30);
	}
}

function increaseFrameSize(newSize){
	var currentSize = window.top.document.body.cols;
	currentSize = parseInt(currentSize.substring(0, currentSize.indexOf(',')));
	if(currentSize == 250){
		return;
	}
	window.top.document.body.cols = newSize+",*";
	if(newSize < 250){
		newSize = newSize * 12 / 9;
		if(newSize > 250){
			newSize = 250;
		}
		setTimeout('increaseFrameSize('+(newSize)+')', 30);
	}

}

function atualizarIndices(capinicial) {
	var cap = 0;
	var subcap = 0;
	var subsubcap = 0;
	var divs = document.getElementsByTagName("div");
	
	//capitulo inicial
	var capInicialFrame = parent.indice.document.getElementById('capituloAberto').value;
	if (capinicial != null ) {
		cap = capinicial - 1;
	}else if(capInicialFrame != null){
		cap = capInicialFrame - 1;
	}
	
	for (var i = 0; i < divs.length; i++) {
		var d = divs[i];
		if (d.className == "titulo") {
			cap++;
			d.innerHTML = "" + cap + " - " + d.innerHTML;
			subcap = 0;
		}
		if (d.className == "subtitulo") {
			subcap++;
			d.innerHTML = "" + cap + "." + subcap + " - " + d.innerHTML;
			subsubcap = 0;
		}
		if (d.className == "subsubtitulo") {
			subsubcap++;
			d.innerHTML = "" + cap + "." + subcap + "." + subsubcap + " - " + d.innerHTML;
		}
	}
}

var palavrasReservadas = ["public", "private", "static", "void", "class", "if", "else", "return", "package", "import", "extends", "implements", "new", "throw", "throws", "this", "protected", "null"];
function configCodes() {
	var codes = document.getElementsByTagName("pre");
	while (codes.length > 0) {
		var texto = codes[0].innerHTML;
		var linhas = contarLinhas(texto);
		var jsp = false;
		if (texto.substring(0, 5) == "[JSP]") {
			texto = texto.substring(5, texto.length);
			jsp = true;
		}
		var textoEstruturado = estruturar(texto, jsp);
		if (jsp) {
			textoEstruturado.splice(0, 1);
			linhas--;
		}
		estilizar(textoEstruturado, jsp);
		var tabela = document.createElement("table");
		tabela.border = 0;
		tabela.cellpadding = 0;
		tabela.cellspacing = 0;
		var tr = tabela.insertRow(0);
		var td1 = tr.insertCell(0);
		var td2 = tr.insertCell(1);
		var textoLinhas = "";
		if (navigator.appName == "Netscape") {
			linhas--;
			textoEstruturado.length = textoEstruturado.length - 1;
		}
		for (var j = 0; j < linhas; j++) {
			textoLinhas += (j + 1);
			if (j + 1 < linhas) {
				textoLinhas += "<BR>";
			}
		}
		tabela.className = "codigo";
		td1.className = "blocoLinhas";
		td2.className = "blocoCodigo";
		td1.valign = "top";
		td2.valign = "top";
		td1.innerHTML = textoLinhas;
		td2.innerHTML = textoEstruturado.join("");
		codes[0].parentNode.replaceChild(tabela, codes[0]);
	}
}

function estilizar(estrutura, jsp) {
	var inTag = false;
	
	OUTER:
	for (var i = 0; i < estrutura.length; i++) {
		var key = estrutura[i];
		for (var j = 0; j < palavrasReservadas.length; j++) {
			var pr = palavrasReservadas[j];
			if (key == pr) {
				key = "<span class=\"palavraReservada\">" + key + "</span>";
				estrutura[i] = key;
				continue OUTER;
			}
		}
		//ver se  tag

		if (jsp) {
			if (key.substring(0, 3) == "&lt" || key.substring(0, 3) == "&gt" || key.substring(0, 4) == "/&gt") {
				key = "<span class=\"tag\">" + key + "</span>";
				estrutura[i] = key;
			} else {
				if (key == ">") {
					key = "<span class=\"tag\">" + key + "</span>";
					estrutura[i] = key;
				} else {
					if (ehAtributo(key)) {
						var keyvalue = key.split("=");
						key = "<span class=\"atributonome\">" + keyvalue[0] + "</span>=<span class=\"atributo\">" + keyvalue[1] + "</span>";
						estrutura[i] = key;
					} else {
						if (key.indexOf("[ATTR]") >= 0) {
							key = "<span class=\"atributo\">" + key.substring("[ATTR]".length, key.length) + "</span>";
							estrutura[i] = key;
						}
					}
				}
			}
		} else {
			var l = key.length;
			if (l > 0 && key.charAt(0) == "\"" && key.charAt(key.length - 1) == "\"") {
				key = "<span class=\"string\">" + key + "</span>";
				estrutura[i] = key;
			}
			if (l > 0 && key.charAt(0) == "@") {
				key = "<span class=\"annotation\">" + key + "</span>";
				estrutura[i] = key;
			}
		}
	}
}

function ehAtributo(key) {
	var temIgual = false;
	var temAspas = false;
	for (var i = 0; i < key.length; i++) {
		if (key.charAt(i) == "\"" || key.charAt(i) == "'") {
			temAspas = true;
		}
		if (key.charAt(i) == "=") {
			temIgual = true;
		}
	}
	return temIgual && temAspas;
}

var NOVO = 1;
var ESPACO = 2;
var TOKEN = 3;
function estruturar(texto, jsp) {
	var tokenAtual = "";
	var listaToken = new Array();
	var status = NOVO;
	for (var i = 0; i < texto.length; i++) {
		var char = texto.charAt(i);
		if (char == " " || char == "\t") {
			if (status == NOVO || status == ESPACO) {
				if (char == " ") {
					char = "&nbsp;";
				} else {
					if (char == "\t") {
						char = "&nbsp;&nbsp;&nbsp;&nbsp;";
					}
				}
				tokenAtual += char;
			} else {
				listaToken.push(tokenAtual);
				tokenAtual = char;
			}
			status = ESPACO;
		} else {
			if (char == "\n" || char == "\r") {
				if (tokenAtual != "") {
					listaToken.push(tokenAtual);
				}
				if (char == "\n") {
					listaToken.push("<BR>");
				}
				tokenAtual = "";
				status = NOVO;
			} else {
				if (!jsp) {
					if (char == "(" || char == ")" || char == "=" || char == "." || char == "," || char == ";") {
						listaToken.push(tokenAtual);
						listaToken.push(char);
						tokenAtual = "";
						status = NOVO;
						continue;
					}
				}
				if (status == ESPACO) {
					listaToken.push(tokenAtual);
					tokenAtual = char;
				} else {
					tokenAtual += char;
				}
				status = TOKEN;
			}
		}
	}
	listaToken.push(tokenAtual);
	if (jsp) {
		for (var i = listaToken.length - 1; i >= 0; i--) {
			if (listaToken[i].length > 5) {
				if (listaToken[i].lastIndexOf("/&gt;") == listaToken[i].length - 5) {
					var x1 = listaToken[i].substring(0, listaToken[i].lastIndexOf("/&gt;"));
					var x2 = "/&gt;";
					if (x1 != "") {
						listaToken.splice(i, 1, x1, x2);
					}
				} else if (listaToken[i] != "<BR>" && listaToken[i].lastIndexOf("&gt;") == listaToken[i].length - 4) {
					var x1 = listaToken[i].substring(0, listaToken[i].lastIndexOf("&gt;"));
					var x2 = "&gt;";
					listaToken.splice(i, 1, x1, x2);
				} else if(listaToken[i].indexOf("&gt;") > 0){
					var x1 = listaToken[i].substring(0, listaToken[i].indexOf("&gt;"));
					var x2 = "&gt;"
					var x3 = listaToken[i].substring(listaToken[i].indexOf("&gt;") + 4, listaToken[i].length);
					if (x1 != "") {
						listaToken.splice(i, 1, x1, x2, x3);
					}
				} 
				if(listaToken[i].indexOf("&lt;/") > 0){
					var x1 = listaToken[i].substring(0, listaToken[i].indexOf("&lt;/"));
					var x2 = listaToken[i].substring(listaToken[i].indexOf("&lt;/"), listaToken[i].length);
					if (x1 != "") {
						listaToken.splice(i, 1, x1, x2);
					}
				}
				if(listaToken[i].indexOf("&gt;") > 0 && listaToken[i].indexOf("&gt;") < listaToken[i].length){
					var x1 = listaToken[i].substring(0, listaToken[i].indexOf("&gt;") + 4);
					var x2 = listaToken[i].substring(listaToken[i].indexOf("&gt;") +  4, listaToken[i].length);
					if (x1 != "") {
						listaToken.splice(i, 1, x1, x2);
					}
				}
			}
		}
	}
	return listaToken;
}

function contarLinhas(texto) {
	var linhas = 1;
	for (var j = 0; j < texto.length; j++) {
		if (texto.charAt(j) == "\n") {
			linhas++;
		}
	}
	return linhas;
}