/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRCsvSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_CSV = ".csv";
    public static final JRCsvSaveContributor INSTANCE = new JRCsvSaveContributor();

    public static JRCsvSaveContributor getInstance() {
        return INSTANCE;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_CSV);
    }

    public String getDescription() {
        return "CSV (*.csv)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_CSV)) {
            file = new File(file.getAbsolutePath() + EXTENSION_CSV);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName()), ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"), 2)) {
            JRCsvExporter jRCsvExporter = new JRCsvExporter();
            jRCsvExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            jRCsvExporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            jRCsvExporter.exportReport();
        }
    }
}

