/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.SAXException;

public class JRDesignViewer
extends JPanel {
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_DESIGN = 3;
    private static final int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250};
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    private JRReport report = null;
    private float zoom = 1.0f;
    private int screenResolution = 72;
    private float realZoom = 0.0f;
    private int offsetY = 0;
    private int upColumns = 0;
    private int downColumns = 0;
    private int downX = 0;
    private int downY = 0;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected TextRenderer textRenderer = new TextRenderer();
    private static final double THIN_CORNER_OFFSET = 0.25;
    private static final double ONE_POINT_CORNER_OFFSET = 0.5;
    private static final Stroke STROKE_THIN = new BasicStroke(0.5f);
    private static final Stroke STROKE_1_POINT = new BasicStroke(1.0f);
    private static final Stroke STROKE_2_POINT = new BasicStroke(2.0f);
    private static final Stroke STROKE_4_POINT = new BasicStroke(4.0f);
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    private static final Stroke BORDER_STROKE_THIN = new BasicStroke(0.5f, 0, 0);
    private static final Stroke BORDER_STROKE_1_POINT = new BasicStroke(1.0f, 0, 0);
    private static final Stroke BORDER_STROKE_DOTTED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    protected JPanel tlbToolBar;
    private JPanel pnlInScroll;
    private JPanel jPanel4;
    private JPanel pnlPage;
    private JLabel jLabel1;
    private JScrollPane scrollPane;
    private JPanel pnlMain;
    private JPanel pnlSep02;
    private JButton btnReload;
    private JPanel jPanel5;
    private JButton btnZoomOut;
    private JLabel lblPage;
    private JPanel jPanel8;
    private JButton btnZoomIn;
    private JPanel jPanel7;
    private JPanel pnlSep01;
    private JPanel jPanel6;
    private JComboBox cmbZoom;
    private JPanel jPanel9;

    public JRDesignViewer(String string, boolean bl) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(string, bl);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(InputStream inputStream, boolean bl) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(inputStream, bl);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(JRReport jRReport) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(jRReport);
        this.cmbZoom.setSelectedIndex(2);
    }

    private void setScreenDetails() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        this.setZoom(1.0f);
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.pnlSep02 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < zooms.length; ++i) {
            defaultComboBoxModel.addElement("" + zooms[i] + "%");
        }
        this.cmbZoom.setModel(defaultComboBoxModel);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new JLabel();
        this.setLayout(new BorderLayout());
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setText("Reload");
        this.btnReload.setToolTipText("Reload Document");
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(80, 23));
        this.btnReload.setMinimumSize(new Dimension(80, 23));
        this.btnReload.setPreferredSize(new Dimension(80, 23));
        this.btnReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRDesignViewer.this.btnReloadActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText("Zoom In");
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRDesignViewer.this.btnZoomInActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText("Zoom Out");
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRDesignViewer.this.btnZoomOutActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setToolTipText("Zoom Ratio");
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRDesignViewer.this.cmbZoomActionPerformed();
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        this.lblPage.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JRDesignViewer.this.lblPageMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JRDesignViewer.this.lblPageMouseReleased();
            }
        });
        this.lblPage.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                JRDesignViewer.this.lblPageMouseDragged(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
    }

    void btnReloadActionPerformed() {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.refreshDesign();
            }
            catch (JRException jRException) {
                jRException.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    void btnZoomInActionPerformed() {
        int n = this.cmbZoom.getSelectedIndex();
        if (n < this.cmbZoom.getModel().getSize() - 1) {
            this.cmbZoom.setSelectedIndex(n + 1);
        }
    }

    void btnZoomOutActionPerformed() {
        int n = this.cmbZoom.getSelectedIndex();
        if (n > 0) {
            this.cmbZoom.setSelectedIndex(n - 1);
        }
    }

    void lblPageMousePressed(MouseEvent mouseEvent) {
        this.lblPage.setCursor(new Cursor(13));
        this.downX = mouseEvent.getX();
        this.downY = mouseEvent.getY();
    }

    void lblPageMouseReleased() {
        this.lblPage.setCursor(new Cursor(0));
    }

    void lblPageMouseDragged(MouseEvent mouseEvent) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Point point = jViewport.getViewPosition();
            int n = point.x - (mouseEvent.getX() - this.downX);
            int n2 = point.y - (mouseEvent.getY() - this.downY);
            int n3 = this.pnlInScroll.getWidth() - jViewport.getWidth();
            int n4 = this.pnlInScroll.getHeight() - jViewport.getHeight();
            if (n < 0) {
                n = 0;
            }
            if (n > n3) {
                n = n3;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            jViewport.setViewPosition(new Point(n, n2));
        }
    }

    void cmbZoomActionPerformed() {
        int n = this.cmbZoom.getSelectedIndex();
        this.setZoom((float)zooms[n] / 100.0f);
        this.btnZoomIn.setEnabled(n < this.cmbZoom.getModel().getSize() - 1);
        this.btnZoomOut.setEnabled(n > 0);
        this.refreshDesign();
    }

    private void setZoom(float f) {
        this.zoom = f;
        this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection collection = JasperCompileManager.verifyDesign(jasperDesign);
        if (collection != null && collection.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Report definition not valid : ");
            int n = 1;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n\t " + n + ". " + (String)iterator.next());
                ++n;
            }
            throw new JRException(stringBuffer.toString());
        }
    }

    private void loadReport(String string, boolean bl) throws JRException {
        if (bl) {
            JasperDesign jasperDesign = JRXmlLoader.load(string);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(string));
        }
        this.type = 1;
        this.isXML = bl;
        this.reportFileName = string;
        this.setOffsetY();
        this.btnReload.setEnabled(true);
    }

    private void loadReport(InputStream inputStream, boolean bl) throws JRException {
        if (bl) {
            JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(inputStream));
        }
        this.type = 2;
        this.isXML = bl;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    private void loadReport(JRReport jRReport) throws JRException {
        this.setReport(jRReport);
        this.type = 3;
        this.isXML = false;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    private void setReport(JRReport jRReport) throws JRException {
        if (jRReport instanceof JasperDesign) {
            this.verifyDesign((JasperDesign)jRReport);
        }
        this.report = jRReport;
    }

    public void setOffsetY() {
        int n;
        this.offsetY = this.report.getTopMargin();
        this.offsetY += this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0;
        this.offsetY += this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0;
        this.upColumns = this.offsetY;
        this.offsetY += this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0;
        JRGroup jRGroup = null;
        JRGroup[] jRGroupArray = this.report.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (n = 0; n < jRGroupArray.length; ++n) {
                jRGroup = jRGroupArray[n];
                this.offsetY += jRGroup.getGroupHeader() != null ? jRGroup.getGroupHeader().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0;
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (n = jRGroupArray.length - 1; n >= 0; --n) {
                jRGroup = jRGroupArray[n];
                this.offsetY += jRGroup.getGroupFooter() != null ? jRGroup.getGroupFooter().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0;
        this.downColumns = this.offsetY;
        this.offsetY += this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0;
        this.offsetY += this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0;
        this.offsetY += this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0;
        this.offsetY += this.report.getBottomMargin();
    }

    private void refreshDesign() {
        Image image = null;
        ImageIcon imageIcon = null;
        Dimension dimension = new Dimension((int)((float)this.report.getPageWidth() * this.realZoom) + 8, (int)((float)this.offsetY * this.realZoom) + 8);
        this.pnlPage.setMaximumSize(dimension);
        this.pnlPage.setMinimumSize(dimension);
        this.pnlPage.setPreferredSize(dimension);
        try {
            image = this.printDesignToImage();
            imageIcon = new ImageIcon(image);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.lblPage.setIcon(imageIcon);
    }

    private Image printDesignToImage() {
        BufferedImage bufferedImage = new BufferedImage((int)((float)this.report.getPageWidth() * this.realZoom) + 1, (int)((float)this.offsetY * this.realZoom) + 1, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(this.realZoom, this.realZoom);
        graphics2D.transform(affineTransform);
        this.printDesign(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void printDesign(Graphics2D graphics2D) {
        int n;
        BasicStroke basicStroke = new BasicStroke(1.0f / this.realZoom, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        Color color = new Color(170, 170, 255);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.report.getPageWidth() + 1, this.offsetY + 1);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(this.report.getLeftMargin(), 0, this.report.getLeftMargin(), this.offsetY + 1);
        graphics2D.drawLine(this.report.getPageWidth() - this.report.getRightMargin(), 0, this.report.getPageWidth() - this.report.getRightMargin(), this.offsetY + 1);
        graphics2D.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth(), this.downColumns);
        graphics2D.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.downColumns);
        graphics2D.translate(this.report.getLeftMargin(), this.report.getTopMargin());
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getTitle(), graphics2D);
        graphics2D.translate(0, this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageHeader(), graphics2D);
        graphics2D.translate(0, this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnHeader(), graphics2D);
        graphics2D.translate(0, this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0);
        JRGroup jRGroup = null;
        JRGroup[] jRGroupArray = this.report.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (n = 0; n < jRGroupArray.length; ++n) {
                jRGroup = jRGroupArray[n];
                graphics2D.setStroke(basicStroke);
                graphics2D.setColor(color);
                graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke(1.0f));
                this.printBand(jRGroup.getGroupHeader(), graphics2D);
                graphics2D.translate(0, jRGroup.getGroupHeader() != null ? jRGroup.getGroupHeader().getHeight() : 0);
            }
        }
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getDetail(), graphics2D);
        graphics2D.translate(0, this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0);
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (n = jRGroupArray.length - 1; n >= 0; --n) {
                jRGroup = jRGroupArray[n];
                graphics2D.setStroke(basicStroke);
                graphics2D.setColor(color);
                graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke(1.0f));
                this.printBand(jRGroup.getGroupFooter(), graphics2D);
                graphics2D.translate(0, jRGroup.getGroupFooter() != null ? jRGroup.getGroupFooter().getHeight() : 0);
            }
        }
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnFooter(), graphics2D);
        graphics2D.translate(0, this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageFooter(), graphics2D);
        graphics2D.translate(0, this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getLastPageFooter(), graphics2D);
        graphics2D.translate(0, this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getSummary(), graphics2D);
        graphics2D.translate(0, this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
    }

    private void printBand(JRBand jRBand, Graphics2D graphics2D) {
        if (jRBand != null) {
            this.printElements(jRBand.getElements(), graphics2D);
        }
    }

    protected void printElements(JRElement[] jRElementArray, Graphics2D graphics2D) {
        if (jRElementArray != null && jRElementArray.length > 0) {
            for (int i = 0; i < jRElementArray.length; ++i) {
                JRElement jRElement = jRElementArray[i];
                if (jRElement instanceof JRLine) {
                    this.printLine((JRLine)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JRRectangle) {
                    this.printRectangle((JRRectangle)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JREllipse) {
                    this.printEllipse((JREllipse)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JRImage) {
                    this.printImage((JRImage)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JRStaticText) {
                    this.printText((JRTextElement)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JRTextField) {
                    this.printText((JRTextElement)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JRSubreport) {
                    this.printSubreport((JRSubreport)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JRChart) {
                    this.printChart((JRChart)jRElement, graphics2D);
                    continue;
                }
                if (jRElement instanceof JRCrosstab) {
                    this.printCrosstab((JRCrosstab)jRElement, graphics2D);
                    continue;
                }
                if (!(jRElement instanceof JRFrame)) continue;
                this.printFrame((JRFrame)jRElement, graphics2D);
            }
        }
    }

    private void printLine(JRLine jRLine, Graphics2D graphics2D) {
        graphics2D.setColor(jRLine.getForecolor());
        Stroke stroke = JRDesignViewer.getStroke(jRLine.getPen());
        if (stroke != null) {
            graphics2D.setStroke(stroke);
            graphics2D.translate(0.5, 0.5);
            if (jRLine.getDirection() == 1) {
                graphics2D.drawLine(jRLine.getX(), jRLine.getY(), jRLine.getX() + jRLine.getWidth() - 1, jRLine.getY() + jRLine.getHeight() - 1);
            } else {
                graphics2D.drawLine(jRLine.getX(), jRLine.getY() + jRLine.getHeight() - 1, jRLine.getX() + jRLine.getWidth() - 1, jRLine.getY());
            }
            graphics2D.translate(-0.5, -0.5);
        }
    }

    private void printRectangle(JRRectangle jRRectangle, Graphics2D graphics2D) {
        if (jRRectangle.getMode() == 1) {
            graphics2D.setColor(jRRectangle.getBackcolor());
            if (jRRectangle.getRadius() > 0) {
                graphics2D.fillRoundRect(jRRectangle.getX(), jRRectangle.getY(), jRRectangle.getWidth(), jRRectangle.getHeight(), 2 * jRRectangle.getRadius(), 2 * jRRectangle.getRadius());
            } else {
                graphics2D.fillRect(jRRectangle.getX(), jRRectangle.getY(), jRRectangle.getWidth(), jRRectangle.getHeight());
            }
        }
        graphics2D.setColor(jRRectangle.getForecolor());
        byte by = jRRectangle.getPen();
        Stroke stroke = JRDesignViewer.getStroke(by);
        if (stroke != null) {
            double d = JRDesignViewer.getBorderCornerOffset(by);
            int n = JRDesignViewer.getRectangleSizeAdjust(by);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((double)jRRectangle.getX() + d, (double)jRRectangle.getY() + d);
            if (by == 5) {
                graphics2D.scale(((double)jRRectangle.getWidth() - 0.5) / (double)jRRectangle.getWidth(), ((double)jRRectangle.getHeight() - 0.5) / (double)jRRectangle.getHeight());
            }
            graphics2D.setStroke(stroke);
            if (jRRectangle.getRadius() > 0) {
                graphics2D.drawRoundRect(0, 0, jRRectangle.getWidth() - n, jRRectangle.getHeight() - n, 2 * jRRectangle.getRadius(), 2 * jRRectangle.getRadius());
            } else {
                graphics2D.drawRect(0, 0, jRRectangle.getWidth() - n, jRRectangle.getHeight() - n);
            }
            graphics2D.setTransform(affineTransform);
        }
    }

    private static double getBorderCornerOffset(byte by) {
        switch (by) {
            case 5: {
                return 0.25;
            }
            case 1: 
            case 4: {
                return 0.5;
            }
        }
        return 0.0;
    }

    private static int getRectangleSizeAdjust(byte by) {
        switch (by) {
            case 1: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private void printEllipse(JREllipse jREllipse, Graphics2D graphics2D) {
        if (jREllipse.getMode() == 1) {
            graphics2D.setColor(jREllipse.getBackcolor());
            graphics2D.fillOval(jREllipse.getX(), jREllipse.getY(), jREllipse.getWidth(), jREllipse.getHeight());
        }
        graphics2D.setColor(jREllipse.getForecolor());
        byte by = jREllipse.getPen();
        Stroke stroke = JRDesignViewer.getStroke(by);
        if (stroke != null) {
            double d = JRDesignViewer.getBorderCornerOffset(by);
            int n = JRDesignViewer.getRectangleSizeAdjust(by);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((double)jREllipse.getX() + d, (double)jREllipse.getY() + d);
            if (by == 5) {
                graphics2D.scale(((double)jREllipse.getWidth() - 0.5) / (double)jREllipse.getWidth(), ((double)jREllipse.getHeight() - 0.5) / (double)jREllipse.getHeight());
            }
            graphics2D.setStroke(stroke);
            graphics2D.drawOval(0, 0, jREllipse.getWidth() - n, jREllipse.getHeight() - n);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void printImage(JRImage jRImage, Graphics2D graphics2D) {
        Object object;
        if (jRImage.getMode() == 1) {
            graphics2D.setColor(jRImage.getBackcolor());
            graphics2D.fillRect(jRImage.getX(), jRImage.getY(), jRImage.getWidth(), jRImage.getHeight());
        }
        int n = jRImage.getTopPadding();
        int n2 = jRImage.getLeftPadding();
        int n3 = jRImage.getBottomPadding();
        int n4 = jRImage.getRightPadding();
        int n5 = jRImage.getWidth() - n2 - n4;
        n5 = n5 < 0 ? 0 : n5;
        int n6 = jRImage.getHeight() - n - n3;
        int n7 = n6 = n6 < 0 ? 0 : n6;
        if (n5 > 0 && n6 > 0) {
            String string;
            Object object2;
            object = null;
            JRExpression jRExpression = jRImage.getExpression();
            if (jRExpression != null && jRExpression.getChunks().length == 1 && (object2 = jRExpression.getChunks()[0]).getType() == 1 && (string = object2.getText().trim()).startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
                try {
                    object = JRImageLoader.loadImage(JRImageLoader.loadImageDataFromLocation(string));
                }
                catch (JRException jRException) {
                    jRException.printStackTrace();
                }
            }
            if (object != null) {
                int n8 = ((Image)object).getWidth(null);
                int n9 = ((Image)object).getHeight(null);
                float f = 0.0f;
                switch (jRImage.getHorizontalAlignment()) {
                    case 3: {
                        f = 1.0f;
                        break;
                    }
                    case 2: {
                        f = 0.5f;
                        break;
                    }
                    default: {
                        f = 0.0f;
                    }
                }
                float f2 = 0.0f;
                switch (jRImage.getVerticalAlignment()) {
                    case 3: {
                        f2 = 1.0f;
                        break;
                    }
                    case 2: {
                        f2 = 0.5f;
                        break;
                    }
                    default: {
                        f2 = 0.0f;
                    }
                }
                switch (jRImage.getScaleImage()) {
                    case 1: {
                        int n10 = (int)(f * (float)(n5 - n8));
                        int n11 = (int)(f2 * (float)(n6 - n9));
                        Shape shape = graphics2D.getClip();
                        graphics2D.clipRect(jRImage.getX() + n2, jRImage.getY() + n, n5, n6);
                        graphics2D.drawImage((Image)object, jRImage.getX() + n2 + n10, jRImage.getY() + n + n11, n8, n9, this);
                        graphics2D.setClip(shape);
                        break;
                    }
                    case 2: {
                        graphics2D.drawImage((Image)object, jRImage.getX() + n2, jRImage.getY() + n, n5, n6, this);
                        break;
                    }
                    default: {
                        if (jRImage.getHeight() > 0) {
                            double d = (double)n8 / (double)n9;
                            if (d > (double)n5 / (double)n6) {
                                n8 = n5;
                                n9 = (int)((double)n5 / d);
                            } else {
                                n8 = (int)((double)n6 * d);
                                n9 = n6;
                            }
                            int n12 = (int)(f * (float)(n5 - n8));
                            int n13 = (int)(f2 * (float)(n6 - n9));
                            graphics2D.drawImage((Image)object, jRImage.getX() + n2 + n12, jRImage.getY() + n + n13, n8, n9, this);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                try {
                    object = JRImageLoader.getImage((byte)1);
                }
                catch (JRException jRException) {
                    jRException.printStackTrace();
                }
                object2 = graphics2D.getClip();
                graphics2D.clipRect(jRImage.getX() + n2, jRImage.getY() + n, n5, n6);
                graphics2D.drawImage((Image)object, jRImage.getX() + n2 + 2, jRImage.getY() + n + 2, ((Image)object).getWidth(null), ((Image)object).getHeight(null), this);
                graphics2D.setClip((Shape)object2);
            }
        }
        if (jRImage.getTopBorder() == 0 && jRImage.getLeftBorder() == 0 && jRImage.getBottomBorder() == 0 && jRImage.getRightBorder() == 0) {
            if (jRImage.getPen() != 0) {
                object = new JRBaseBox(jRImage.getPen(), jRImage.getForecolor());
                this.printBox((JRBox)object, jRImage, graphics2D);
            }
        } else {
            this.printBox(jRImage, jRImage, graphics2D);
        }
    }

    private JRStyledText getStyledText(JRTextElement jRTextElement) {
        Object object;
        JRStyledText jRStyledText = null;
        String string = null;
        if (jRTextElement instanceof JRStaticText) {
            string = ((JRStaticText)jRTextElement).getText();
        } else if (jRTextElement instanceof JRTextField && (object = ((JRTextField)jRTextElement).getExpression()) != null) {
            string = object.getText();
        }
        if (string == null) {
            string = "";
        }
        object = new HashMap();
        JRFontUtil.setAttributes((Map)object, jRTextElement);
        object.put(TextAttribute.FOREGROUND, jRTextElement.getForecolor());
        if (jRTextElement instanceof JRStaticText && jRTextElement.isStyledText()) {
            try {
                jRStyledText = this.styledTextParser.parse((Map)object, string);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        if (jRStyledText == null) {
            jRStyledText = new JRStyledText();
            jRStyledText.append(string);
            jRStyledText.addRun(new JRStyledText.Run((Map)object, 0, string.length()));
        }
        return jRStyledText;
    }

    private void printText(JRTextElement jRTextElement, Graphics2D graphics2D) {
        JRStyledText jRStyledText = this.getStyledText(jRTextElement);
        if (jRStyledText == null) {
            return;
        }
        String string = jRStyledText.getText();
        int n = jRTextElement.getX();
        int n2 = jRTextElement.getY();
        int n3 = jRTextElement.getWidth();
        int n4 = jRTextElement.getHeight();
        int n5 = jRTextElement.getTopPadding();
        int n6 = jRTextElement.getLeftPadding();
        int n7 = jRTextElement.getBottomPadding();
        int n8 = jRTextElement.getRightPadding();
        double d = 0.0;
        switch (jRTextElement.getRotation()) {
            case 1: {
                n2 = jRTextElement.getY() + jRTextElement.getHeight();
                n3 = jRTextElement.getHeight();
                n4 = jRTextElement.getWidth();
                int n9 = n5;
                n5 = n6;
                n6 = n7;
                n7 = n8;
                n8 = n9;
                d = -1.5707963267948966;
                break;
            }
            case 2: {
                n = jRTextElement.getX() + jRTextElement.getWidth();
                n3 = jRTextElement.getHeight();
                n4 = jRTextElement.getWidth();
                int n9 = n5;
                n5 = n8;
                n8 = n7;
                n7 = n6;
                n6 = n9;
                d = 1.5707963267948966;
                break;
            }
        }
        graphics2D.rotate(d, n, n2);
        if (jRTextElement.getMode() == 1) {
            graphics2D.setColor(jRTextElement.getBackcolor());
            graphics2D.fillRect(n, n2, n3, n4);
        }
        graphics2D.setColor(jRTextElement.getForecolor());
        TextMeasurer textMeasurer = new TextMeasurer(jRTextElement);
        textMeasurer.measure(jRStyledText, string, 0, 0);
        this.textRenderer.render(graphics2D, n, n2, n3, n4, n5, n6, n7, n8, textMeasurer.getTextHeight(), jRTextElement.getHorizontalAlignment(), jRTextElement.getVerticalAlignment(), textMeasurer.getLineSpacingFactor(), textMeasurer.getLeadingOffset(), jRTextElement.getFontSize(), jRTextElement.isStyledText(), jRStyledText, string);
        graphics2D.rotate(-d, n, n2);
        this.printBox(jRTextElement, jRTextElement, graphics2D);
    }

    private void printBox(JRBox jRBox, Color color, int n, int n2, int n3, int n4, Graphics2D graphics2D) {
        double d;
        Stroke stroke = null;
        Stroke stroke2 = null;
        Stroke stroke3 = null;
        Stroke stroke4 = null;
        if (jRBox != null) {
            stroke = JRDesignViewer.getBorderStroke(jRBox.getTopBorder());
            stroke2 = JRDesignViewer.getBorderStroke(jRBox.getLeftBorder());
            stroke3 = JRDesignViewer.getBorderStroke(jRBox.getBottomBorder());
            stroke4 = JRDesignViewer.getBorderStroke(jRBox.getRightBorder());
        }
        if (stroke != null) {
            d = JRDesignViewer.getBorderCornerOffset(jRBox.getTopBorder());
            graphics2D.setStroke(stroke);
            graphics2D.setColor(jRBox.getTopBorderColor() == null ? color : jRBox.getTopBorderColor());
            graphics2D.translate(0.0, d);
            graphics2D.drawLine(n, n2, n + n3, n2);
            graphics2D.translate(0.0, -d);
        }
        if (stroke2 != null) {
            d = JRDesignViewer.getBorderCornerOffset(jRBox.getLeftBorder());
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(jRBox.getLeftBorderColor() == null ? color : jRBox.getLeftBorderColor());
            graphics2D.translate(d, 0.0);
            graphics2D.drawLine(n, n2, n, n2 + n4);
            graphics2D.translate(-d, 0.0);
        }
        if (stroke3 != null) {
            d = JRDesignViewer.getBorderCornerOffset(jRBox.getBottomBorder());
            graphics2D.setStroke(stroke3);
            graphics2D.setColor(jRBox.getBottomBorderColor() == null ? color : jRBox.getBottomBorderColor());
            graphics2D.translate(0.0, -d);
            graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
            graphics2D.translate(0.0, d);
        }
        if (stroke4 != null) {
            d = JRDesignViewer.getBorderCornerOffset(jRBox.getRightBorder());
            graphics2D.setStroke(stroke4);
            graphics2D.setColor(jRBox.getRightBorderColor() == null ? color : jRBox.getRightBorderColor());
            graphics2D.translate(-d, 0.0);
            graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
            graphics2D.translate(d, 0.0);
        }
        if (stroke == null && stroke2 == null && stroke3 == null && stroke4 == null) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(1.0f / this.realZoom));
            graphics2D.drawRect(n, n2, n3, n4);
        }
    }

    private static Stroke getBorderStroke(byte by) {
        switch (by) {
            case 4: {
                return BORDER_STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return BORDER_STROKE_THIN;
            }
        }
        return BORDER_STROKE_1_POINT;
    }

    private void printBox(JRBox jRBox, JRElement jRElement, Graphics2D graphics2D) {
        this.printBox(jRBox, jRElement.getForecolor(), jRElement.getX(), jRElement.getY(), jRElement.getWidth(), jRElement.getHeight(), graphics2D);
    }

    private void printSubreport(JRSubreport jRSubreport, Graphics2D graphics2D) {
        if (jRSubreport.getMode() == 1) {
            graphics2D.setColor(jRSubreport.getBackcolor());
            graphics2D.fillRect(jRSubreport.getX(), jRSubreport.getY(), jRSubreport.getWidth(), jRSubreport.getHeight());
        }
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)2);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(jRSubreport.getX(), jRSubreport.getY(), jRSubreport.getWidth(), jRSubreport.getHeight());
        graphics2D.drawImage(image, jRSubreport.getX() + 2, jRSubreport.getY() + 2, image.getWidth(null), image.getHeight(null), this);
        graphics2D.setClip(shape);
        graphics2D.setColor(jRSubreport.getForecolor());
        graphics2D.setStroke(new BasicStroke(1.0f / this.realZoom));
        graphics2D.drawRect(jRSubreport.getX(), jRSubreport.getY(), jRSubreport.getWidth() - 1, jRSubreport.getHeight() - 1);
    }

    private void printChart(JRChart jRChart, Graphics2D graphics2D) {
        if (jRChart.getMode() == 1) {
            graphics2D.setColor(jRChart.getBackcolor());
            graphics2D.fillRect(jRChart.getX(), jRChart.getY(), jRChart.getWidth(), jRChart.getHeight());
        }
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)3);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
        graphics2D.setClip(jRChart.getX(), jRChart.getY(), jRChart.getWidth(), jRChart.getHeight());
        graphics2D.drawImage(image, jRChart.getX() + 2, jRChart.getY() + 2, image.getWidth(null), image.getHeight(null), this);
        graphics2D.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
        graphics2D.setColor(jRChart.getForecolor());
        graphics2D.setStroke(new BasicStroke(1.0f / this.realZoom));
        graphics2D.drawRect(jRChart.getX(), jRChart.getY(), jRChart.getWidth() - 1, jRChart.getHeight() - 1);
    }

    private void printCrosstab(JRCrosstab jRCrosstab, Graphics2D graphics2D) {
        graphics2D.setClip(jRCrosstab.getX(), jRCrosstab.getY(), jRCrosstab.getWidth(), jRCrosstab.getHeight());
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        int n = 0;
        for (int i = 0; i < jRCrosstabRowGroupArray.length; ++i) {
            n += jRCrosstabRowGroupArray[i].getWidth();
        }
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        int n2 = 0;
        for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
            n2 += jRCrosstabColumnGroupArray[i].getHeight();
        }
        JRCellContents jRCellContents = jRCrosstab.getHeaderCell();
        if (jRCellContents != null) {
            graphics2D.translate(jRCrosstab.getX(), jRCrosstab.getY());
            this.printCellContents(jRCellContents, graphics2D, 0, 0, false, false);
            graphics2D.translate(-jRCrosstab.getX(), -jRCrosstab.getY());
        }
        graphics2D.translate(jRCrosstab.getX() + n, jRCrosstab.getY());
        this.printCrosstabColumnHeaders(jRCrosstab, graphics2D);
        graphics2D.translate(-(jRCrosstab.getX() + n), -jRCrosstab.getY());
        graphics2D.translate(jRCrosstab.getX(), jRCrosstab.getY() + n2);
        this.printCrosstabRows(jRCrosstab, graphics2D, n);
        graphics2D.translate(-jRCrosstab.getX(), -(jRCrosstab.getY() + n2));
        graphics2D.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
    }

    private void printCrosstabColumnHeaders(JRCrosstab jRCrosstab, Graphics2D graphics2D) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
            JRCellContents jRCellContents;
            JRCrosstabColumnGroup jRCrosstabColumnGroup = jRCrosstabColumnGroupArray[i];
            if (jRCrosstabColumnGroup.getTotalPosition() == 1) {
                jRCellContents = jRCrosstabColumnGroup.getTotalHeader();
                this.printCellContents(jRCellContents, graphics2D, n, n2, n == 0 && jRCrosstab.getHeaderCell() == null, false);
                n += jRCellContents.getWidth();
            }
            jRCellContents = jRCrosstabColumnGroup.getHeader();
            this.printCellContents(jRCellContents, graphics2D, n, n2, n == 0 && jRCrosstab.getHeaderCell() == null, false);
            if (jRCrosstabColumnGroup.getTotalPosition() == 2) {
                JRCellContents jRCellContents2 = jRCrosstabColumnGroup.getTotalHeader();
                this.printCellContents(jRCellContents2, graphics2D, n + jRCellContents.getWidth(), n2, false, false);
            }
            n2 += jRCrosstabColumnGroup.getHeight();
        }
    }

    private void printCrosstabRows(JRCrosstab jRCrosstab, Graphics2D graphics2D, int n) {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < jRCrosstabRowGroupArray.length; ++i) {
            JRCellContents jRCellContents;
            JRCrosstabRowGroup jRCrosstabRowGroup = jRCrosstabRowGroupArray[i];
            if (jRCrosstabRowGroup.getTotalPosition() == 1) {
                jRCellContents = jRCrosstabRowGroup.getTotalHeader();
                this.printCellContents(jRCellContents, graphics2D, n2, n3, false, n3 == 0 && jRCrosstab.getHeaderCell() == null);
                this.printCrosstabDataCellsRow(jRCrosstab, graphics2D, n, n3, i);
                n3 += jRCellContents.getHeight();
            }
            jRCellContents = jRCrosstabRowGroup.getHeader();
            this.printCellContents(jRCellContents, graphics2D, n2, n3, false, n3 == 0 && jRCrosstab.getHeaderCell() == null);
            if (i == jRCrosstabRowGroupArray.length - 1) {
                this.printCrosstabDataCellsRow(jRCrosstab, graphics2D, n, n3, jRCrosstabRowGroupArray.length);
            }
            if (jRCrosstabRowGroup.getTotalPosition() == 2) {
                JRCellContents jRCellContents2 = jRCrosstabRowGroup.getTotalHeader();
                this.printCellContents(jRCellContents2, graphics2D, n2, n3 + jRCellContents.getHeight(), false, false);
                this.printCrosstabDataCellsRow(jRCrosstab, graphics2D, n, n3 + jRCellContents.getHeight(), i);
            }
            n2 += jRCrosstabRowGroup.getWidth();
        }
    }

    private void printCrosstabDataCellsRow(JRCrosstab jRCrosstab, Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.translate(n, n2);
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
        int n4 = 0;
        for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
            JRCrosstabColumnGroup jRCrosstabColumnGroup = jRCrosstabColumnGroupArray[i];
            if (jRCrosstabColumnGroup.getTotalPosition() == 1) {
                this.printCellContents(jRCrosstabCellArray[n3][i].getContents(), graphics2D, n4, 0, false, false);
                n4 += jRCrosstabCellArray[n3][i].getContents().getWidth();
            }
            if (i == jRCrosstabColumnGroupArray.length - 1) {
                this.printCellContents(jRCrosstabCellArray[n3][jRCrosstabColumnGroupArray.length].getContents(), graphics2D, n4, 0, false, false);
            }
            if (jRCrosstabColumnGroup.getTotalPosition() != 2) continue;
            this.printCellContents(jRCrosstabCellArray[n3][i].getContents(), graphics2D, n4 + jRCrosstabColumnGroup.getHeader().getWidth(), 0, false, false);
        }
        graphics2D.translate(-n, -n2);
    }

    private void printCellContents(JRCellContents jRCellContents, Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2) {
        if (jRCellContents.getWidth() == 0 || jRCellContents.getHeight() == 0) {
            return;
        }
        JRDesignFrame jRDesignFrame = this.createCrosstabCellFrame(jRCellContents, n, n2, bl, bl2);
        this.printFrame(jRDesignFrame, graphics2D);
    }

    private JRDesignFrame createCrosstabCellFrame(JRCellContents jRCellContents, int n, int n2, boolean bl, boolean bl2) {
        List list;
        JRDesignFrame jRDesignFrame = new JRDesignFrame(jRCellContents.getDefaultStyleProvider());
        jRDesignFrame.setX(n);
        jRDesignFrame.setY(n2);
        jRDesignFrame.setWidth(jRCellContents.getWidth());
        jRDesignFrame.setHeight(jRCellContents.getHeight());
        jRDesignFrame.setMode(jRCellContents.getMode());
        jRDesignFrame.setBackcolor(jRCellContents.getBackcolor());
        jRDesignFrame.setStyle(jRCellContents.getStyle());
        JRBox jRBox = jRCellContents.getBox();
        if (jRBox != null) {
            boolean bl3;
            jRDesignFrame.setBox(jRBox);
            boolean bl4 = bl && jRBox.getLeftBorder() == 0 && jRBox.getRightBorder() != 0;
            boolean bl5 = bl3 = bl2 && jRBox.getTopBorder() == 0 && jRBox.getBottomBorder() != 0;
            if (bl4) {
                jRDesignFrame.setLeftBorder(jRBox.getRightBorder());
                jRDesignFrame.setLeftBorderColor(jRBox.getRightBorderColor());
            }
            if (bl3) {
                jRDesignFrame.setTopBorder(jRBox.getBottomBorder());
                jRDesignFrame.setTopBorderColor(jRBox.getBottomBorderColor());
            }
        }
        if ((list = jRCellContents.getChildren()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRChild jRChild = (JRChild)iterator.next();
                if (jRChild instanceof JRElement) {
                    jRDesignFrame.addElement((JRElement)jRChild);
                    continue;
                }
                if (!(jRChild instanceof JRElementGroup)) continue;
                jRDesignFrame.addElementGroup((JRElementGroup)jRChild);
            }
        }
        return jRDesignFrame;
    }

    private void printFrame(JRFrame jRFrame, Graphics2D graphics2D) {
        if (jRFrame.getMode() == 1) {
            graphics2D.setColor(jRFrame.getBackcolor());
            graphics2D.fillRect(jRFrame.getX(), jRFrame.getY(), jRFrame.getWidth(), jRFrame.getHeight());
        }
        int n = jRFrame.getTopPadding();
        int n2 = jRFrame.getLeftPadding();
        graphics2D.translate(jRFrame.getX() + n2, jRFrame.getY() + n);
        this.printElements(jRFrame.getElements(), graphics2D);
        graphics2D.translate(-(jRFrame.getX() + n2), -(jRFrame.getY() + n));
        this.printBox(jRFrame, jRFrame, graphics2D);
    }

    private static Stroke getStroke(byte by) {
        switch (by) {
            case 4: {
                return STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return STROKE_THIN;
            }
        }
        return STROKE_1_POINT;
    }
}

