/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRXmlLoader {
    private JasperDesign jasperDesign = null;
    private Collection groupReprintedElements = new ArrayList();
    private Collection groupEvaluatedImages = new ArrayList();
    private Collection groupEvaluatedTextFields = new ArrayList();
    private Collection groupEvaluatedCharts = new ArrayList();
    private Set groupBoundDatasets = new HashSet();
    private List errors = new ArrayList();
    private Digester digester = null;
    private boolean ignoreConsistencyProblems;

    public JRXmlLoader(Digester digester) {
        this.digester = digester;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public Collection getGroupReprintedElements() {
        return this.groupReprintedElements;
    }

    public Collection getGroupEvaluatedImages() {
        return this.groupEvaluatedImages;
    }

    public Collection getGroupEvaluatedTextFields() {
        return this.groupEvaluatedTextFields;
    }

    public Collection getGroupEvaluatedCharts() {
        return this.groupEvaluatedCharts;
    }

    public Set getGroupBoundDatasets() {
        return this.groupBoundDatasets;
    }

    public static JasperDesign load(String string) throws JRException {
        return JRXmlLoader.load(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JasperDesign load(File file) throws JRException {
        JasperDesign jasperDesign = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                jasperDesign = JRXmlLoader.load(fileInputStream);
            }
            catch (IOException iOException) {
                throw new JRException(iOException);
            }
            Object var5_3 = null;
            if (fileInputStream == null) return jasperDesign;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return jasperDesign;
    }

    public static JasperDesign load(InputStream inputStream) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader jRXmlLoader = null;
        try {
            jRXmlLoader = new JRXmlLoader(JRXmlDigesterFactory.createDigester());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JRException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new JRException(sAXException);
        }
        jasperDesign = jRXmlLoader.loadXML(inputStream);
        return jasperDesign;
    }

    public JasperDesign loadXML(InputStream inputStream) throws JRException {
        return this.loadXML(new InputSource(inputStream));
    }

    public JasperDesign loadXML(InputSource inputSource) throws JRException {
        try {
            this.digester.push((Object)this);
            this.digester.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new JRException(sAXException);
        }
        catch (IOException iOException) {
            throw new JRException(iOException);
        }
        finally {
            this.digester.clear();
        }
        if (this.errors.size() > 0) {
            Exception exception = (Exception)this.errors.get(0);
            if (exception instanceof JRException) {
                throw (JRException)exception;
            }
            throw new JRException(exception);
        }
        this.assignGroupsToVariables(this.jasperDesign.getMainDesignDataset());
        Iterator iterator = this.jasperDesign.getDatasetsList().iterator();
        while (iterator.hasNext()) {
            JRDesignDataset jRDesignDataset = (JRDesignDataset)iterator.next();
            this.assignGroupsToVariables(jRDesignDataset);
        }
        this.assignGroupsToElements();
        this.assignGroupsToImages();
        this.assignGroupsToTextFields();
        this.assignGroupsToCharts();
        this.assignGroupsToDatasets();
        return this.jasperDesign;
    }

    private void assignGroupsToVariables(JRDesignDataset jRDesignDataset) throws JRException {
        JRVariable[] jRVariableArray = jRDesignDataset.getVariables();
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            Map map = jRDesignDataset.getGroupsMap();
            for (int i = 0; i < jRVariableArray.length; ++i) {
                JRGroup jRGroup;
                String string;
                JRDesignVariable jRDesignVariable = (JRDesignVariable)jRVariableArray[i];
                if (jRDesignVariable.getResetType() == 4) {
                    string = null;
                    jRGroup = jRDesignVariable.getResetGroup();
                    if (jRGroup != null) {
                        string = jRGroup.getName();
                        jRGroup = (JRGroup)map.get(string);
                    }
                    if (!this.ignoreConsistencyProblems && jRGroup == null) {
                        throw new JRException("Unknown reset group '" + string + "' for variable : " + jRDesignVariable.getName());
                    }
                    jRDesignVariable.setResetGroup(jRGroup);
                } else {
                    jRDesignVariable.setResetGroup(null);
                }
                if (jRDesignVariable.getIncrementType() == 4) {
                    string = null;
                    jRGroup = jRDesignVariable.getIncrementGroup();
                    if (jRGroup != null) {
                        string = jRGroup.getName();
                        jRGroup = (JRGroup)map.get(string);
                    }
                    if (!this.ignoreConsistencyProblems && jRGroup == null) {
                        throw new JRException("Unknown increment group '" + string + "' for variable : " + jRDesignVariable.getName());
                    }
                    jRDesignVariable.setIncrementGroup(jRGroup);
                    continue;
                }
                jRDesignVariable.setIncrementGroup(null);
            }
        }
    }

    private void assignGroupsToElements() throws JRException {
        Map map = this.jasperDesign.getGroupsMap();
        JRDesignElement jRDesignElement = null;
        String string = null;
        JRGroup jRGroup = null;
        Iterator iterator = this.groupReprintedElements.iterator();
        while (iterator.hasNext()) {
            jRDesignElement = (JRDesignElement)iterator.next();
            string = null;
            jRGroup = jRDesignElement.getPrintWhenGroupChanges();
            if (jRGroup != null) {
                string = jRGroup.getName();
                jRGroup = (JRGroup)map.get(jRGroup.getName());
            }
            if (!this.ignoreConsistencyProblems && jRGroup == null) {
                throw new JRException("Unknown reprint group '" + string + "' for element.");
            }
            jRDesignElement.setPrintWhenGroupChanges(jRGroup);
        }
    }

    private void assignGroupsToImages() throws JRException {
        Map map = this.jasperDesign.getGroupsMap();
        JRDesignImage jRDesignImage = null;
        String string = null;
        JRGroup jRGroup = null;
        Iterator iterator = this.groupEvaluatedImages.iterator();
        while (iterator.hasNext()) {
            jRDesignImage = (JRDesignImage)iterator.next();
            string = null;
            jRGroup = jRDesignImage.getEvaluationGroup();
            if (jRGroup != null) {
                string = jRGroup.getName();
                jRGroup = (JRGroup)map.get(jRGroup.getName());
            }
            if (!this.ignoreConsistencyProblems && jRGroup == null) {
                throw new JRException("Unknown evaluation group '" + string + "' for image.");
            }
            jRDesignImage.setEvaluationGroup(jRGroup);
        }
    }

    private void assignGroupsToTextFields() throws JRException {
        Map map = this.jasperDesign.getGroupsMap();
        JRDesignTextField jRDesignTextField = null;
        String string = null;
        JRGroup jRGroup = null;
        Iterator iterator = this.groupEvaluatedTextFields.iterator();
        while (iterator.hasNext()) {
            jRDesignTextField = (JRDesignTextField)iterator.next();
            string = null;
            jRGroup = jRDesignTextField.getEvaluationGroup();
            if (jRGroup != null) {
                string = jRGroup.getName();
                jRGroup = (JRGroup)map.get(jRGroup.getName());
            }
            if (!this.ignoreConsistencyProblems && jRGroup == null) {
                throw new JRException("Unknown evaluation group '" + string + "' for text field.");
            }
            jRDesignTextField.setEvaluationGroup(jRGroup);
        }
    }

    private void assignGroupsToCharts() throws JRException {
        Map map = this.jasperDesign.getGroupsMap();
        Iterator iterator = this.groupEvaluatedCharts.iterator();
        while (iterator.hasNext()) {
            JRDesignChart jRDesignChart = (JRDesignChart)iterator.next();
            String string = null;
            JRGroup jRGroup = jRDesignChart.getEvaluationGroup();
            if (jRGroup != null) {
                string = jRGroup.getName();
                jRGroup = (JRGroup)map.get(jRGroup.getName());
            }
            if (!this.ignoreConsistencyProblems && jRGroup == null) {
                throw new JRException("Unknown evaluation group '" + string + "' for chart.");
            }
            jRDesignChart.setEvaluationGroup(jRGroup);
        }
    }

    private void assignGroupsToDatasets() throws JRException {
        Iterator iterator = this.groupBoundDatasets.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Map map;
            JRDesignElementDataset jRDesignElementDataset = (JRDesignElementDataset)iterator.next();
            JRDatasetRun jRDatasetRun = jRDesignElementDataset.getDatasetRun();
            if (jRDatasetRun == null) {
                map = this.jasperDesign.getGroupsMap();
            } else {
                object2 = this.jasperDesign.getDatasetMap();
                JRDesignDataset jRDesignDataset = (JRDesignDataset)object2.get(object = jRDatasetRun.getDatasetName());
                if (jRDesignDataset == null) {
                    throw new JRException("Unknown sub dataset '" + (String)object + "' for chart dataset.");
                }
                map = jRDesignDataset.getGroupsMap();
            }
            if (jRDesignElementDataset.getIncrementType() == 4) {
                object2 = null;
                object = jRDesignElementDataset.getIncrementGroup();
                if (object != null) {
                    object2 = object.getName();
                    object = (JRGroup)map.get(object.getName());
                }
                if (!this.ignoreConsistencyProblems && object == null) {
                    throw new JRException("Unknown increment group '" + (String)object2 + "' for chart dataset.");
                }
                jRDesignElementDataset.setIncrementGroup((JRGroup)object);
            } else {
                jRDesignElementDataset.setIncrementGroup(null);
            }
            if (jRDesignElementDataset.getResetType() == 4) {
                object2 = null;
                object = jRDesignElementDataset.getResetGroup();
                if (object != null) {
                    object2 = object.getName();
                    object = (JRGroup)map.get(object.getName());
                }
                if (!this.ignoreConsistencyProblems && object == null) {
                    throw new JRException("Unknown reset group '" + (String)object2 + "' for chart dataset.");
                }
                jRDesignElementDataset.setResetGroup((JRGroup)object);
                continue;
            }
            jRDesignElementDataset.setResetGroup(null);
        }
    }

    public void addError(Exception exception) {
        if (!this.ignoreConsistencyProblems) {
            this.errors.add(exception);
        }
    }

    public boolean isIgnoreConsistencyProblems() {
        return this.ignoreConsistencyProblems;
    }

    public void setIgnoreConsistencyProblems(boolean bl) {
        this.ignoreConsistencyProblems = bl;
    }
}

