/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRStyledTextParser {
    private static final String ROOT_START = "<st>";
    private static final String ROOT_END = "</st>";
    private static final String NODE_style = "style";
    private static final String NODE_bold = "b";
    private static final String NODE_italic = "i";
    private static final String NODE_underline = "u";
    private static final String NODE_font = "font";
    private static final String NODE_br = "br";
    private static final String NODE_li = "li";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_fontFace = "face";
    private static final String ATTRIBUTE_color = "color";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_forecolor = "forecolor";
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    private static final String SPACE = " ";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private static final String SHARP = "#";
    private static final String LESS = "<";
    private static final String LESS_SLASH = "</";
    private static final String GREATER = ">";
    private static final String SIX_ZEROS = "000000";
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);
    private DocumentBuilder documentBuilder = null;

    public JRStyledTextParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JRRuntimeException(parserConfigurationException);
        }
    }

    public JRStyledText parse(Map map, String string) throws SAXException {
        JRStyledText jRStyledText = new JRStyledText();
        Document document = null;
        try {
            document = this.documentBuilder.parse(new InputSource(new StringReader(ROOT_START + string + ROOT_END)));
        }
        catch (IOException iOException) {
            throw new JRRuntimeException(iOException);
        }
        this.parseStyle(jRStyledText, document.getDocumentElement());
        jRStyledText.addRun(new JRStyledText.Run(map, 0, jRStyledText.length()));
        return jRStyledText;
    }

    public String write(Map map, AttributedCharacterIterator attributedCharacterIterator, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < attributedCharacterIterator.getEndIndex() && (n = attributedCharacterIterator.getRunLimit()) <= attributedCharacterIterator.getEndIndex()) {
            String string2 = string.substring(attributedCharacterIterator.getIndex(), n);
            Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
            StringBuffer stringBuffer2 = this.writeStyleAttributes(map, map2);
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(LESS);
                stringBuffer.append(NODE_style);
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append(GREATER);
                stringBuffer.append(string2);
                stringBuffer.append(LESS_SLASH);
                stringBuffer.append(NODE_style);
                stringBuffer.append(GREATER);
            } else {
                stringBuffer.append(string2);
            }
            attributedCharacterIterator.setIndex(n);
        }
        return stringBuffer.toString();
    }

    private void parseStyle(JRStyledText jRStyledText, Node node) throws SAXException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            String string;
            HashMap<AttributedCharacterIterator.Attribute, Object> hashMap;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) {
                jRStyledText.append(node2.getNodeValue());
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_style.equals(node2.getNodeName())) {
                char c;
                Color color;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (namedNodeMap.getNamedItem(ATTRIBUTE_fontName) != null) {
                    hashMap.put(TextAttribute.FAMILY, namedNodeMap.getNamedItem(ATTRIBUTE_fontName).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isBold) != null) {
                    hashMap.put(TextAttribute.WEIGHT, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isBold).getNodeValue()) != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isItalic) != null) {
                    hashMap.put(TextAttribute.POSTURE, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isItalic).getNodeValue()) != false ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isUnderline) != null) {
                    hashMap.put(TextAttribute.UNDERLINE, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isUnderline).getNodeValue()) != false ? TextAttribute.UNDERLINE_ON : null);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isStrikeThrough) != null) {
                    hashMap.put(TextAttribute.STRIKETHROUGH, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isStrikeThrough).getNodeValue()) != false ? TextAttribute.STRIKETHROUGH_ON : null);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_size) != null) {
                    hashMap.put(TextAttribute.SIZE, new Float(namedNodeMap.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_pdfFontName) != null) {
                    hashMap.put(JRTextAttribute.PDF_FONT_NAME, namedNodeMap.getNamedItem(ATTRIBUTE_pdfFontName).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_pdfEncoding) != null) {
                    hashMap.put(JRTextAttribute.PDF_ENCODING, namedNodeMap.getNamedItem(ATTRIBUTE_pdfEncoding).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isPdfEmbedded) != null) {
                    hashMap.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isPdfEmbedded).getNodeValue()));
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_forecolor) != null) {
                    color = null;
                    string = namedNodeMap.getNamedItem(ATTRIBUTE_forecolor).getNodeValue();
                    if (string != null && string.length() > 0) {
                        c = string.charAt(0);
                        color = c == '#' ? new Color(Integer.parseInt(string.substring(1), 16)) : ('0' <= c && c <= '9' ? new Color(Integer.parseInt(string)) : (JRXmlConstants.getColorMap().containsKey(string) ? (Color)JRXmlConstants.getColorMap().get(string) : Color.black));
                    }
                    hashMap.put(TextAttribute.FOREGROUND, color);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_backcolor) != null) {
                    color = null;
                    string = namedNodeMap.getNamedItem(ATTRIBUTE_backcolor).getNodeValue();
                    if (string != null && string.length() > 0) {
                        c = string.charAt(0);
                        color = c == '#' ? new Color(Integer.parseInt(string.substring(1), 16)) : ('0' <= c && c <= '9' ? new Color(Integer.parseInt(string)) : (JRXmlConstants.getColorMap().containsKey(string) ? (Color)JRXmlConstants.getColorMap().get(string) : Color.black));
                    }
                    hashMap.put(TextAttribute.BACKGROUND, color);
                }
                n = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_bold.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Float> hashMap2 = new HashMap<TextAttribute, Float>();
                hashMap2.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                int n2 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap2, n2, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_italic.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Float> hashMap3 = new HashMap<TextAttribute, Float>();
                hashMap3.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                int n3 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap3, n3, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_underline.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Integer> hashMap4 = new HashMap<TextAttribute, Integer>();
                hashMap4.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                int n4 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap4, n4, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_font.equalsIgnoreCase(node2.getNodeName())) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                hashMap = new HashMap();
                if (namedNodeMap.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    hashMap.put(JRTextAttribute.HTML_FONT_FACE, namedNodeMap.getNamedItem(ATTRIBUTE_fontFace).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_size) != null) {
                    hashMap.put(TextAttribute.SIZE, new Float(namedNodeMap.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_color) != null) {
                    Color color = null;
                    string = namedNodeMap.getNamedItem(ATTRIBUTE_color).getNodeValue();
                    if (string != null && string.length() > 0) {
                        char c = string.charAt(0);
                        color = c == '#' ? new Color(Integer.parseInt(string.substring(1), 16)) : ('0' <= c && c <= '9' ? new Color(Integer.parseInt(string)) : (JRXmlConstants.getColorMap().containsKey(string) ? (Color)JRXmlConstants.getColorMap().get(string) : Color.black));
                    }
                    hashMap.put(TextAttribute.FOREGROUND, color);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    string = namedNodeMap.getNamedItem(ATTRIBUTE_fontFace).getNodeValue();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    block1: while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken().trim();
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (!stringArray[j].equals(string2)) continue;
                            hashMap.put(TextAttribute.FAMILY, string2);
                            break block1;
                        }
                    }
                }
                n = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_br.equalsIgnoreCase(node2.getNodeName())) {
                jRStyledText.append("\n");
                int n5 = jRStyledText.length();
                this.resizeRuns(jRStyledText.getRuns(), n5, 1);
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(new HashMap(), n5, jRStyledText.length()));
                if (n5 >= jRStyledText.length()) continue;
                jRStyledText.append("\n");
                this.resizeRuns(jRStyledText.getRuns(), n5, 1);
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_li.equalsIgnoreCase(node2.getNodeName())) {
                jRStyledText.append("\n \u2022 ");
                int n6 = jRStyledText.length();
                this.resizeRuns(jRStyledText.getRuns(), n6, 1);
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(new HashMap(), n6, jRStyledText.length()));
                jRStyledText.append("\n");
                this.resizeRuns(jRStyledText.getRuns(), n6, 1);
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            String string3 = LESS + node2.getNodeName() + GREATER;
            throw new SAXException("Tag " + string3 + " is not a valid styled text tag.");
        }
    }

    private void resizeRuns(List list, int n, int n2) {
        for (int i = 0; i < list.size(); ++i) {
            JRStyledText.Run run = (JRStyledText.Run)list.get(i);
            if (run.startIndex > n || run.endIndex <= n - n2) continue;
            run.endIndex += n2;
        }
    }

    private StringBuffer writeStyleAttributes(Map map, Map map2) {
        StringBuffer stringBuffer = new StringBuffer();
        Object v = map2.get(TextAttribute.FAMILY);
        Object v2 = map.get(TextAttribute.FAMILY);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_fontName);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v);
            stringBuffer.append(QUOTE);
        }
        v = map2.get(TextAttribute.WEIGHT);
        v2 = map.get(TextAttribute.WEIGHT);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isBold);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v.equals(TextAttribute.WEIGHT_BOLD));
            stringBuffer.append(QUOTE);
        }
        v = map2.get(TextAttribute.POSTURE);
        v2 = map.get(TextAttribute.POSTURE);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isItalic);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v.equals(TextAttribute.POSTURE_OBLIQUE));
            stringBuffer.append(QUOTE);
        }
        v = map2.get(TextAttribute.UNDERLINE);
        v2 = map.get(TextAttribute.UNDERLINE);
        if (v == null && v2 != null || v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isUnderline);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v != null);
            stringBuffer.append(QUOTE);
        }
        v = map2.get(TextAttribute.STRIKETHROUGH);
        v2 = map.get(TextAttribute.STRIKETHROUGH);
        if (v == null && v2 != null || v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isStrikeThrough);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v != null);
            stringBuffer.append(QUOTE);
        }
        v = map2.get(TextAttribute.SIZE);
        v2 = map.get(TextAttribute.SIZE);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_size);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(((Float)v).intValue());
            stringBuffer.append(QUOTE);
        }
        v = map2.get(JRTextAttribute.PDF_FONT_NAME);
        v2 = map.get(JRTextAttribute.PDF_FONT_NAME);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_pdfFontName);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v);
            stringBuffer.append(QUOTE);
        }
        v = map2.get(JRTextAttribute.PDF_ENCODING);
        v2 = map.get(JRTextAttribute.PDF_ENCODING);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_pdfEncoding);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v);
            stringBuffer.append(QUOTE);
        }
        v = map2.get(JRTextAttribute.IS_PDF_EMBEDDED);
        v2 = map.get(JRTextAttribute.IS_PDF_EMBEDDED);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isPdfEmbedded);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v);
            stringBuffer.append(QUOTE);
        }
        v = map2.get(TextAttribute.FOREGROUND);
        v2 = map.get(TextAttribute.FOREGROUND);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_forecolor);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(SHARP);
            stringBuffer.append(this.getHexaColor((Color)v));
            stringBuffer.append(QUOTE);
        }
        v = map2.get(TextAttribute.BACKGROUND);
        v2 = map.get(TextAttribute.BACKGROUND);
        if (v != null && !v.equals(v2)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_backcolor);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(SHARP);
            stringBuffer.append(this.getHexaColor((Color)v));
            stringBuffer.append(QUOTE);
        }
        return stringBuffer;
    }

    private String getHexaColor(Color color) {
        String string = Integer.toHexString(color.getRGB() & colorMask).toUpperCase();
        return (SIX_ZEROS + string).substring(string.length());
    }
}

