/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public class JRQueryExecuterUtils {
    private static final Map factoryCache = new HashMap();

    public static JRQueryExecuterFactory getQueryExecuterFactory(String string) throws JRException {
        String string2 = JRProperties.getProperty("net.sf.jasperreports.query.executer.factory." + string);
        if (string2 == null) {
            throw new JRException("No query executer factory class registered for " + string + " queries.  " + "Create a propery named " + "net.sf.jasperreports.query.executer.factory." + string + ".");
        }
        JRQueryExecuterFactory jRQueryExecuterFactory = JRQueryExecuterUtils.getCachedFactory(string2);
        if (jRQueryExecuterFactory == null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(string2);
                jRQueryExecuterFactory = (JRQueryExecuterFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRException("Query executer factory class " + string2 + " not found.", classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new JRException("Error instantiating query executer factory " + string2 + ".", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JRException("Error instantiating query executer factory " + string2 + ".", illegalAccessException);
            }
            JRQueryExecuterUtils.cacheFactory(string2, jRQueryExecuterFactory);
        }
        return jRQueryExecuterFactory;
    }

    private static synchronized JRQueryExecuterFactory getCachedFactory(String string) {
        return (JRQueryExecuterFactory)factoryCache.get(string);
    }

    private static synchronized void cacheFactory(String string, JRQueryExecuterFactory jRQueryExecuterFactory) {
        factoryCache.put(string, jRQueryExecuterFactory);
    }
}

