/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter == null ? (class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter = JRJdbcQueryExecuter.class$("net.sf.jasperreports.engine.query.JRJdbcQueryExecuter")) : class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter));
    private Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    private PreparedStatement statement;
    private ResultSet resultSet;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    public JRJdbcQueryExecuter(JRDataset jRDataset, Map map) {
        super(jRDataset, map);
        if (this.connection == null && log.isWarnEnabled()) {
            log.warn((Object)"The supplied java.sql.Connection object is null.");
        }
        this.parseQuery();
    }

    protected String getParameterReplacement(String string) {
        return "?";
    }

    public JRDataSource createDatasource() throws JRException {
        JRResultSetDataSource jRResultSetDataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                Integer n = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
                if (n != null) {
                    this.statement.setMaxRows(n);
                }
                this.resultSet = this.statement.executeQuery();
                jRResultSetDataSource = new JRResultSetDataSource(this.resultSet);
            }
            catch (SQLException sQLException) {
                throw new JRException("Error executing SQL statement for : " + this.dataset.getName(), sQLException);
            }
        }
        return jRResultSetDataSource;
    }

    private void createStatement() throws JRException {
        String string = this.getQueryString();
        if (this.connection != null && string != null && string.trim().length() > 0) {
            try {
                List list;
                this.statement = this.connection.prepareStatement(string);
                int n = JRProperties.getIntegerProperty(this.dataset.getPropertiesMap(), "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (n > 0) {
                    this.statement.setFetchSize(n);
                }
                if (!(list = this.getCollectedParameterNames()).isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        String string2 = (String)list.get(i);
                        JRFillParameter jRFillParameter = this.getParameter(string2);
                        Class clazz = jRFillParameter.getValueClass();
                        Object object = jRFillParameter.getValue();
                        if (clazz.equals(class$java$lang$Object == null ? JRJdbcQueryExecuter.class$("java.lang.Object") : class$java$lang$Object)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 2000);
                                continue;
                            }
                            this.statement.setObject(i + 1, object);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Boolean == null ? JRJdbcQueryExecuter.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, -7);
                                continue;
                            }
                            this.statement.setBoolean(i + 1, (Boolean)object);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Byte == null ? JRJdbcQueryExecuter.class$("java.lang.Byte") : class$java$lang$Byte)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, -6);
                                continue;
                            }
                            this.statement.setByte(i + 1, (Byte)object);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Double == null ? JRJdbcQueryExecuter.class$("java.lang.Double") : class$java$lang$Double)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 8);
                                continue;
                            }
                            this.statement.setDouble(i + 1, (Double)object);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Float == null ? JRJdbcQueryExecuter.class$("java.lang.Float") : class$java$lang$Float)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 6);
                                continue;
                            }
                            this.statement.setFloat(i + 1, ((Float)object).floatValue());
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Integer == null ? JRJdbcQueryExecuter.class$("java.lang.Integer") : class$java$lang$Integer)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 4);
                                continue;
                            }
                            this.statement.setInt(i + 1, (Integer)object);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Long == null ? JRJdbcQueryExecuter.class$("java.lang.Long") : class$java$lang$Long)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, -5);
                                continue;
                            }
                            this.statement.setLong(i + 1, (Long)object);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Short == null ? JRJdbcQueryExecuter.class$("java.lang.Short") : class$java$lang$Short)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 5);
                                continue;
                            }
                            this.statement.setShort(i + 1, (Short)object);
                            continue;
                        }
                        if (clazz.equals(class$java$math$BigDecimal == null ? JRJdbcQueryExecuter.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 3);
                                continue;
                            }
                            this.statement.setBigDecimal(i + 1, (BigDecimal)object);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$String == null ? JRJdbcQueryExecuter.class$("java.lang.String") : class$java$lang$String)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 12);
                                continue;
                            }
                            this.statement.setString(i + 1, object.toString());
                            continue;
                        }
                        if (clazz.equals(class$java$util$Date == null ? JRJdbcQueryExecuter.class$("java.util.Date") : class$java$util$Date)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 91);
                                continue;
                            }
                            this.statement.setDate(i + 1, new Date(((java.util.Date)object).getTime()));
                            continue;
                        }
                        if (clazz.equals(class$java$sql$Timestamp == null ? JRJdbcQueryExecuter.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 93);
                                continue;
                            }
                            this.statement.setTimestamp(i + 1, (Timestamp)object);
                            continue;
                        }
                        if (clazz.equals(class$java$sql$Time == null ? JRJdbcQueryExecuter.class$("java.sql.Time") : class$java$sql$Time)) {
                            if (object == null) {
                                this.statement.setNull(i + 1, 92);
                                continue;
                            }
                            this.statement.setTime(i + 1, (Time)object);
                            continue;
                        }
                        throw new JRException("Parameter type not supported in query : " + string2 + " class " + clazz.getName());
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + string + "\n\n", sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                log.error((Object)"Error while closing result set.", (Throwable)sQLException);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                log.error((Object)"Error while closing statement.", (Throwable)sQLException);
            }
            finally {
                this.statement = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Throwable throwable) {
                throw new JRException("Error cancelling SQL statement", throwable);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

