/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRHibernateAbstractDataSource;
import net.sf.jasperreports.engine.data.JRHibernateIterateDataSource;
import net.sf.jasperreports.engine.data.JRHibernateListDataSource;
import net.sf.jasperreports.engine.data.JRHibernateScrollDataSource;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class JRHibernateQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$query$JRHibernateQueryExecuter == null ? (class$net$sf$jasperreports$engine$query$JRHibernateQueryExecuter = JRHibernateQueryExecuter.class$("net.sf.jasperreports.engine.query.JRHibernateQueryExecuter")) : class$net$sf$jasperreports$engine$query$JRHibernateQueryExecuter));
    private static final Map hibernateTypeMap = new HashMap();
    private final Integer reportMaxCount;
    private Session session = (Session)this.getParameterValue("HIBERNATE_SESSION");
    private Query query;
    private boolean queryRunning;
    private ScrollableResults scrollableResults;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$query$JRHibernateQueryExecuter;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$util$Collection;

    public JRHibernateQueryExecuter(JRDataset jRDataset, Map map) {
        super(jRDataset, map);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        if (this.session == null) {
            log.warn((Object)"The supplied org.hibernate.Session object is null.");
        }
        this.parseQuery();
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource jRDataSource = null;
        String string = this.getQueryString();
        if (this.session != null && string != null && string.trim().length() > 0) {
            this.createQuery(string);
            jRDataSource = this.createResultDatasource();
        }
        return jRDataSource;
    }

    protected JRDataSource createResultDatasource() {
        JRHibernateAbstractDataSource jRHibernateAbstractDataSource;
        JRPropertiesMap jRPropertiesMap = this.dataset.getPropertiesMap();
        String string = JRProperties.getProperty(jRPropertiesMap, "net.sf.jasperreports.hql.query.run.type");
        boolean bl = JRProperties.getBooleanProperty(jRPropertiesMap, "net.sf.jasperreports.hql.field.mapping.descriptions", true);
        if (string == null || string.equals("list")) {
            try {
                int n = JRProperties.getIntegerProperty(jRPropertiesMap, "net.sf.jasperreports.hql.query.list.page.size", 0);
                jRHibernateAbstractDataSource = new JRHibernateListDataSource(this, bl, n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("The net.sf.jasperreports.hql.query.list.page.size property must be numerical.");
            }
        } else if (string.equals("iterate")) {
            jRHibernateAbstractDataSource = new JRHibernateIterateDataSource(this, bl);
        } else if (string.equals("scroll")) {
            jRHibernateAbstractDataSource = new JRHibernateScrollDataSource(this, bl);
        } else {
            throw new JRRuntimeException("Unknown value for the net.sf.jasperreports.hql.query.run.type property.  Possible values are list, iterate and scroll.");
        }
        return jRHibernateAbstractDataSource;
    }

    protected synchronized void createQuery(String string) {
        Object object = this.getParameterValue("HIBERNATE_FILTER_COLLECTION");
        this.query = object == null ? this.session.createQuery(string) : this.session.createFilter(object, string);
        this.query.setReadOnly(true);
        int n = JRProperties.getIntegerProperty(this.dataset.getPropertiesMap(), "net.sf.jasperreports.jdbc.fetch.size", 0);
        if (n > 0) {
            this.query.setFetchSize(n);
        }
        this.setParameters();
    }

    protected void setParameters() {
        List list = this.getCollectedParameterNames();
        if (!list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!hashSet.add(string)) continue;
                JRFillParameter jRFillParameter = this.getParameter(string);
                this.setParameter(jRFillParameter);
            }
        }
    }

    protected void setParameter(JRFillParameter jRFillParameter) {
        String string = this.getHqlParameterName(jRFillParameter.getName());
        Class clazz = jRFillParameter.getValueClass();
        Object object = jRFillParameter.getValue();
        Type type = (Type)hibernateTypeMap.get(clazz);
        if (type != null) {
            this.query.setParameter(string, object, type);
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = JRHibernateQueryExecuter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            this.query.setParameterList(string, (Collection)object);
        } else if (this.session.getSessionFactory().getClassMetadata(clazz) != null) {
            this.query.setEntity(string, object);
        } else {
            this.query.setParameter(string, object);
        }
    }

    public synchronized void close() {
        this.closeScrollableResults();
        this.query = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeScrollableResults() {
        if (this.scrollableResults != null) {
            try {
                this.scrollableResults.close();
            }
            finally {
                this.scrollableResults = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.queryRunning) {
            this.session.cancelQuery();
            return true;
        }
        return false;
    }

    protected String getParameterReplacement(String string) {
        return ':' + this.getHqlParameterName(string);
    }

    protected String getHqlParameterName(String string) {
        return '_' + JRStringUtil.getLiteral(string);
    }

    public Type[] getReturnTypes() {
        return this.query.getReturnTypes();
    }

    public String[] getReturnAliases() {
        return this.query.getReturnAliases();
    }

    public JRDataset getDataset() {
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            List list = this.query.list();
            return list;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    protected synchronized void setQueryRunning(boolean bl) {
        this.queryRunning = bl;
    }

    private void setMaxCount() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
    }

    public List list(int n, int n2) {
        if (this.reportMaxCount != null && n + n2 > this.reportMaxCount) {
            n2 = this.reportMaxCount - n;
        }
        this.query.setFirstResult(n);
        this.query.setMaxResults(n2);
        return this.query.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            Iterator iterator = this.query.iterate();
            return iterator;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            this.scrollableResults = this.query.scroll(ScrollMode.FORWARD_ONLY);
        }
        finally {
            this.setQueryRunning(false);
        }
        return this.scrollableResults;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        hibernateTypeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRHibernateQueryExecuter.class$("java.lang.Boolean")) : class$java$lang$Boolean, Hibernate.BOOLEAN);
        hibernateTypeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = JRHibernateQueryExecuter.class$("java.lang.Byte")) : class$java$lang$Byte, Hibernate.BYTE);
        hibernateTypeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = JRHibernateQueryExecuter.class$("java.lang.Double")) : class$java$lang$Double, Hibernate.DOUBLE);
        hibernateTypeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = JRHibernateQueryExecuter.class$("java.lang.Float")) : class$java$lang$Float, Hibernate.FLOAT);
        hibernateTypeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = JRHibernateQueryExecuter.class$("java.lang.Integer")) : class$java$lang$Integer, Hibernate.INTEGER);
        hibernateTypeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = JRHibernateQueryExecuter.class$("java.lang.Long")) : class$java$lang$Long, Hibernate.LONG);
        hibernateTypeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = JRHibernateQueryExecuter.class$("java.lang.Short")) : class$java$lang$Short, Hibernate.SHORT);
        hibernateTypeMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRHibernateQueryExecuter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, Hibernate.BIG_DECIMAL);
        hibernateTypeMap.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = JRHibernateQueryExecuter.class$("java.math.BigInteger")) : class$java$math$BigInteger, Hibernate.BIG_INTEGER);
        hibernateTypeMap.put(class$java$lang$Character == null ? (class$java$lang$Character = JRHibernateQueryExecuter.class$("java.lang.Character")) : class$java$lang$Character, Hibernate.CHARACTER);
        hibernateTypeMap.put(class$java$lang$String == null ? (class$java$lang$String = JRHibernateQueryExecuter.class$("java.lang.String")) : class$java$lang$String, Hibernate.STRING);
        hibernateTypeMap.put(class$java$util$Date == null ? (class$java$util$Date = JRHibernateQueryExecuter.class$("java.util.Date")) : class$java$util$Date, Hibernate.DATE);
        hibernateTypeMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRHibernateQueryExecuter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, Hibernate.TIMESTAMP);
        hibernateTypeMap.put(class$java$sql$Time == null ? (class$java$sql$Time = JRHibernateQueryExecuter.class$("java.sql.Time")) : class$java$sql$Time, Hibernate.TIME);
    }
}

