/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;

public abstract class JRAbstractQueryExecuter
implements JRQueryExecuter {
    protected final JRDataset dataset;
    private final Map parametersMap;
    private String queryString;
    private List parameterNames;

    protected JRAbstractQueryExecuter(JRDataset jRDataset, Map map) {
        this.dataset = jRDataset;
        this.parametersMap = map;
        this.queryString = "";
        this.parameterNames = new ArrayList();
    }

    protected void parseQuery() {
        JRQueryChunk[] jRQueryChunkArray;
        JRQuery jRQuery = this.dataset.getQuery();
        if (jRQuery != null && (jRQueryChunkArray = jRQuery.getChunks()) != null && jRQueryChunkArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            JRQueryChunk jRQueryChunk = null;
            block4: for (int i = 0; i < jRQueryChunkArray.length; ++i) {
                jRQueryChunk = jRQueryChunkArray[i];
                switch (jRQueryChunk.getType()) {
                    case 3: {
                        String string = jRQueryChunk.getText();
                        Object object = this.getParameterValue(string);
                        stringBuffer.append(String.valueOf(object));
                        continue block4;
                    }
                    case 2: {
                        stringBuffer.append(this.getParameterReplacement(jRQueryChunk.getText()));
                        this.parameterNames.add(jRQueryChunk.getText());
                        continue block4;
                    }
                    default: {
                        stringBuffer.append(jRQueryChunk.getText());
                    }
                }
            }
            this.queryString = stringBuffer.toString();
        }
    }

    protected String getQueryString() {
        return this.queryString;
    }

    protected List getCollectedParameterNames() {
        return this.parameterNames;
    }

    protected Object getParameterValue(String string) {
        JRFillParameter jRFillParameter = this.getParameter(string);
        return jRFillParameter.getValue();
    }

    protected JRFillParameter getParameter(String string) {
        JRFillParameter jRFillParameter = (JRFillParameter)this.parametersMap.get(string);
        if (jRFillParameter == null) {
            throw new JRRuntimeException("Parameter \"" + string + "\" does not exist.");
        }
        return jRFillParameter;
    }

    protected abstract String getParameterReplacement(String var1);
}

